/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.BridgeSoLoader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0082 \u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/bridge/Inspector;", "", "mHybridData", "Lcom/facebook/jni/HybridData;", "<init>", "(Lcom/facebook/jni/HybridData;)V", "getPagesNative", "", "Lcom/facebook/react/bridge/Inspector$Page;", "()[Lcom/facebook/react/bridge/Inspector$Page;", "connectNative", "Lcom/facebook/react/bridge/Inspector$LocalConnection;", "pageId", "", "remote", "Lcom/facebook/react/bridge/Inspector$RemoteConnection;", "Page", "RemoteConnection", "LocalConnection", "Companion", "ReactAndroid_debug"})
@DoNotStrip
public final class Inspector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HybridData mHybridData;

    private Inspector(HybridData mHybridData) {
        this.mHybridData = mHybridData;
    }

    private final native Page[] getPagesNative();

    private final native LocalConnection connectNative(int var1, RemoteConnection var2);

    @JvmStatic
    @NotNull
    public static final List<Page> getPages() {
        return Companion.getPages();
    }

    @JvmStatic
    @NotNull
    public static final LocalConnection connect(int pageId, @NotNull RemoteConnection remote) {
        return Companion.connect(pageId, remote);
    }

    @JvmStatic
    private static final native Inspector instance();

    static {
        BridgeSoLoader.staticInit();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\t\u0010\r\u001a\u00020\u000eH\u0083 \u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/bridge/Inspector$Companion;", "", "<init>", "()V", "getPages", "", "Lcom/facebook/react/bridge/Inspector$Page;", "connect", "Lcom/facebook/react/bridge/Inspector$LocalConnection;", "pageId", "", "remote", "Lcom/facebook/react/bridge/Inspector$RemoteConnection;", "instance", "Lcom/facebook/react/bridge/Inspector;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Page> getPages() {
            List list;
            try {
                list = ArraysKt.toList((Object[])this.instance().getPagesNative());
            }
            catch (UnsatisfiedLinkError e) {
                FLog.e((String)"ReactNative", (String)"Inspector doesn't work in open source yet", (Throwable)e);
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @JvmStatic
        @NotNull
        public final LocalConnection connect(int pageId, @NotNull RemoteConnection remote) {
            LocalConnection localConnection;
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            try {
                LocalConnection localConnection2 = this.instance().connectNative(pageId, remote);
                if (localConnection2 == null) {
                    throw new IllegalStateException("Can't open failed connection");
                }
                localConnection = localConnection2;
            }
            catch (UnsatisfiedLinkError e) {
                FLog.e((String)"ReactNative", (String)"Inspector doesn't work in open source yet", (Throwable)e);
                throw new RuntimeException(e);
            }
            return localConnection;
        }

        @JvmStatic
        private final Inspector instance() {
            return Inspector.instance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086 J\t\u0010\n\u001a\u00020\u0007H\u0086 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/bridge/Inspector$LocalConnection;", "", "mHybridData", "Lcom/facebook/jni/HybridData;", "<init>", "(Lcom/facebook/jni/HybridData;)V", "sendMessage", "", "message", "", "disconnect", "ReactAndroid_debug"})
    @DoNotStrip
    public static final class LocalConnection {
        @NotNull
        private final HybridData mHybridData;

        private LocalConnection(HybridData mHybridData) {
            this.mHybridData = mHybridData;
        }

        public final native void sendMessage(@NotNull String var1);

        public final native void disconnect();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005J\b\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/bridge/Inspector$Page;", "", "id", "", "title", "", "vm", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getId", "getTitle", "getVM", "toString", "ReactAndroid_debug"})
    @DoNotStrip
    public static final class Page {
        private final int id;
        @NotNull
        private final String title;
        @NotNull
        private final String vm;

        private Page(int id2, String title, String vm) {
            this.id = id2;
            this.title = title;
            this.vm = vm;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getVM() {
            return this.vm;
        }

        @NotNull
        public String toString() {
            return "Page{id=" + this.id + ", title='" + this.title + "'}";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\b\u0010\u0006\u001a\u00020\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/bridge/Inspector$RemoteConnection;", "", "onMessage", "", "message", "", "onDisconnect", "ReactAndroid_debug"})
    @DoNotStrip
    public static interface RemoteConnection {
        @DoNotStrip
        public void onMessage(@NotNull String var1);

        @DoNotStrip
        public void onDisconnect();
    }
}

