/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ComposeShader;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.style.BackgroundImageLayer;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u001bH\u0016J\u0012\u00104\u001a\u00020.2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u00020\u001bH\u0017J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0015H\u0002J\n\u0010<\u001a\u0004\u0018\u00010=H\u0002J\b\u0010>\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010&\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "borderInsets", "Lcom/facebook/react/uimanager/style/BorderInsets;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;Lcom/facebook/react/uimanager/style/BorderInsets;)V", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "getBorderInsets", "()Lcom/facebook/react/uimanager/style/BorderInsets;", "setBorderInsets", "(Lcom/facebook/react/uimanager/style/BorderInsets;)V", "pathAdjustment", "", "computedBorderInsets", "Landroid/graphics/RectF;", "computedBorderRadius", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "needUpdatePath", "", "value", "", "backgroundColor", "getBackgroundColor", "()I", "setBackgroundColor", "(I)V", "backgroundRect", "backgroundRenderPath", "Landroid/graphics/Path;", "", "Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "backgroundImageLayers", "getBackgroundImageLayers", "()Ljava/util/List;", "setBackgroundImageLayers", "(Ljava/util/List;)V", "backgroundPaint", "Landroid/graphics/Paint;", "invalidateSelf", "", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "computeBorderInsets", "getBackgroundImageShader", "Landroid/graphics/Shader;", "updatePath", "ReactAndroid_debug"})
public final class BackgroundDrawable
extends Drawable {
    @NotNull
    private final Context context;
    @Nullable
    private BorderRadiusStyle borderRadius;
    @Nullable
    private BorderInsets borderInsets;
    private final float pathAdjustment;
    @Nullable
    private RectF computedBorderInsets;
    @Nullable
    private ComputedBorderRadius computedBorderRadius;
    private boolean needUpdatePath;
    private int backgroundColor;
    @NotNull
    private RectF backgroundRect;
    @Nullable
    private Path backgroundRenderPath;
    @Nullable
    private List<BackgroundImageLayer> backgroundImageLayers;
    @NotNull
    private final Paint backgroundPaint;

    /*
     * WARNING - void declaration
     */
    public BackgroundDrawable(@NotNull Context context, @Nullable BorderRadiusStyle borderRadius, @Nullable BorderInsets borderInsets) {
        void $this$backgroundPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.borderRadius = borderRadius;
        this.borderInsets = borderInsets;
        this.pathAdjustment = 0.8f;
        this.needUpdatePath = true;
        this.backgroundRect = new RectF();
        Paint paint2 = paint = new Paint(1);
        BackgroundDrawable backgroundDrawable = this;
        boolean bl = false;
        $this$backgroundPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$backgroundPaint_u24lambda_u240.setColor(this.backgroundColor);
        backgroundDrawable.backgroundPaint = paint;
    }

    public /* synthetic */ BackgroundDrawable(Context context, BorderRadiusStyle borderRadiusStyle, BorderInsets borderInsets, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            borderRadiusStyle = null;
        }
        if ((n & 4) != 0) {
            borderInsets = null;
        }
        this(context, borderRadiusStyle, borderInsets);
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    @Nullable
    public final BorderInsets getBorderInsets() {
        return this.borderInsets;
    }

    public final void setBorderInsets(@Nullable BorderInsets borderInsets) {
        this.borderInsets = borderInsets;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(int value) {
        if (this.backgroundColor != value) {
            this.backgroundColor = value;
            this.backgroundPaint.setColor(value);
            this.invalidateSelf();
        }
    }

    @Nullable
    public final List<BackgroundImageLayer> getBackgroundImageLayers() {
        return this.backgroundImageLayers;
    }

    public final void setBackgroundImageLayers(@Nullable List<BackgroundImageLayer> value) {
        if (!Intrinsics.areEqual(this.backgroundImageLayers, value)) {
            this.backgroundImageLayers = value;
            this.invalidateSelf();
        }
    }

    public void invalidateSelf() {
        this.needUpdatePath = true;
        super.invalidateSelf();
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.needUpdatePath = true;
    }

    public void setAlpha(int alpha) {
        this.backgroundPaint.setAlpha(MathKt.roundToInt((float)((float)alpha / 255.0f * ((float)Color.alpha((int)this.backgroundColor) / 255.0f) * 255.0f)));
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int alpha = this.backgroundPaint.getAlpha();
        int n = alpha;
        return n == 255 ? -1 : ((1 <= n ? n < 255 : false) ? -3 : -2);
    }

    /*
     * Unable to fully structure code
     */
    public void draw(@NotNull Canvas canvas) {
        block19: {
            block18: {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                this.updatePath();
                canvas.save();
                if (this.backgroundPaint.getAlpha() == 0) break block18;
                v0 = this.computedBorderRadius;
                v1 = v0 != null ? v0.isUniform() : false;
                if (!v1) ** GOTO lbl-1000
                v2 = this.borderRadius;
                v3 = v2 != null ? v2.hasRoundedBorders() : false;
                if (v3) {
                    v4 = this.computedBorderRadius;
                    if (v4 != null && (v4 = v4.getTopLeft()) != null) {
                        var3_2 = v4.getHorizontal();
                        v5 = PixelUtil.INSTANCE.dpToPx(var3_2);
                    } else {
                        v5 = 0.0f;
                    }
                    if ((v6 = this.computedBorderRadius) != null && (v6 = v6.getTopLeft()) != null) {
                        var3_2 = v6.getVertical();
                        v7 = PixelUtil.INSTANCE.dpToPx(var3_2);
                    } else {
                        v7 = 0.0f;
                    }
                    canvas.drawRoundRect(this.backgroundRect, v5, v7, this.backgroundPaint);
                } else lbl-1000:
                // 2 sources

                {
                    v8 = this.borderRadius;
                    if (!(v8 != null ? v8.hasRoundedBorders() : false)) {
                        canvas.drawRect(this.backgroundRect, this.backgroundPaint);
                    } else {
                        v9 = this.backgroundRenderPath;
                        if (v9 == null) {
                            var2_3 = "Required value was null.";
                            throw new IllegalStateException(var2_3.toString());
                        }
                        canvas.drawPath(v9, this.backgroundPaint);
                    }
                }
            }
            if (this.backgroundImageLayers == null) break block19;
            v10 = this.backgroundImageLayers;
            v11 = v10 != null ? ((Collection)v10).isEmpty() == false : false;
            if (!v11) break block19;
            this.backgroundPaint.setShader(this.getBackgroundImageShader());
            v12 = this.computedBorderRadius;
            v13 = v12 != null ? v12.isUniform() : false;
            if (!v13) ** GOTO lbl-1000
            v14 = this.borderRadius;
            v15 = v14 != null ? v14.hasRoundedBorders() : false;
            if (v15) {
                v16 = this.computedBorderRadius;
                if (v16 != null && (v16 = v16.getTopLeft()) != null) {
                    var3_2 = v16.getHorizontal();
                    v17 = PixelUtil.INSTANCE.dpToPx(var3_2);
                } else {
                    v17 = 0.0f;
                }
                if ((v18 = this.computedBorderRadius) != null && (v18 = v18.getTopLeft()) != null) {
                    var3_2 = v18.getVertical();
                    v19 = PixelUtil.INSTANCE.dpToPx(var3_2);
                } else {
                    v19 = 0.0f;
                }
                canvas.drawRoundRect(this.backgroundRect, v17, v19, this.backgroundPaint);
            } else lbl-1000:
            // 2 sources

            {
                v20 = this.borderRadius;
                if (!(v20 != null ? v20.hasRoundedBorders() : false)) {
                    canvas.drawRect(this.backgroundRect, this.backgroundPaint);
                } else {
                    v21 = this.backgroundRenderPath;
                    if (v21 == null) {
                        var2_4 = "Required value was null.";
                        throw new IllegalStateException(var2_4.toString());
                    }
                    canvas.drawPath(v21, this.backgroundPaint);
                }
            }
            this.backgroundPaint.setShader(null);
        }
        canvas.restore();
    }

    private final RectF computeBorderInsets() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        BorderInsets borderInsets = this.borderInsets;
        RectF it = borderInsets != null ? borderInsets.resolve(this.getLayoutDirection(), this.context) : null;
        boolean bl = false;
        RectF rectF = it;
        if (rectF != null) {
            f5 = rectF.left;
            f4 = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f4 = 0.0f;
        }
        RectF rectF2 = it;
        if (rectF2 != null) {
            f5 = rectF2.top;
            f3 = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f3 = 0.0f;
        }
        RectF rectF3 = it;
        if (rectF3 != null) {
            f5 = rectF3.right;
            f2 = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f2 = 0.0f;
        }
        RectF rectF4 = it;
        if (rectF4 != null) {
            f5 = rectF4.bottom;
            f = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f = 0.0f;
        }
        return new RectF(f4, f3, f2, f);
    }

    private final Shader getBackgroundImageShader() {
        List<BackgroundImageLayer> list = this.backgroundImageLayers;
        if (list != null) {
            List<BackgroundImageLayer> layers = list;
            boolean bl = false;
            Shader compositeShader = null;
            for (BackgroundImageLayer backgroundImageLayer : layers) {
                Shader currentShader;
                Rect rect = this.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
                if (backgroundImageLayer.getShader(rect) == null) continue;
                compositeShader = compositeShader == null ? currentShader : (Shader)new ComposeShader(currentShader, compositeShader, PorterDuff.Mode.SRC_OVER);
            }
            return compositeShader;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final void updatePath() {
        block27: {
            if (!this.needUpdatePath) {
                return;
            }
            this.needUpdatePath = false;
            this.backgroundRect.set(this.getBounds());
            this.computedBorderInsets = this.computeBorderInsets();
            v0 = this.borderRadius;
            this.computedBorderRadius = v0 != null ? v0.resolve(this.getLayoutDirection(), this.context, PixelUtil.INSTANCE.pxToDp(this.getBounds().width()), PixelUtil.INSTANCE.pxToDp(this.getBounds().height())) : null;
            v1 = this.computedBorderInsets;
            if (!Intrinsics.areEqual((Float)(v1 != null ? Float.valueOf(v1.left) : null), (float)0.0f)) ** GOTO lbl-1000
            v2 = this.computedBorderInsets;
            if (!Intrinsics.areEqual((Float)(v2 != null ? Float.valueOf(v2.top) : null), (float)0.0f)) ** GOTO lbl-1000
            v3 = this.computedBorderInsets;
            if (!Intrinsics.areEqual((Float)(v3 != null ? Float.valueOf(v3.right) : null), (float)0.0f)) ** GOTO lbl-1000
            v4 = this.computedBorderInsets;
            if (!Intrinsics.areEqual((Float)(v4 != null ? Float.valueOf(v4.bottom) : null), (float)0.0f)) lbl-1000:
            // 4 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            hasBorder = v5;
            v6 = this.computedBorderRadius;
            v7 = v6 != null ? v6.hasRoundedBorders() : false;
            if (v7) {
                v8 = this.computedBorderRadius;
                v9 = v8 != null ? !v8.isUniform() : false;
                if (v9) {
                    v10 = this.backgroundRenderPath;
                    if (v10 == null) {
                        v10 = new Path();
                    }
                    v11 = this.backgroundRenderPath = v10;
                    if (v11 != null) {
                        v11.reset();
                    }
                }
            }
            if (hasBorder) {
                v12 = this.borderRadius;
                v13 = v12 != null ? v12.hasRoundedBorders() : false;
                if (v13) {
                    var2_2 = this.backgroundRect;
                    var2_2.left += this.pathAdjustment;
                    var2_2 = this.backgroundRect;
                    var2_2.top += this.pathAdjustment;
                    var2_2 = this.backgroundRect;
                    var2_2.right -= this.pathAdjustment;
                    var2_2 = this.backgroundRect;
                    var2_2.bottom -= this.pathAdjustment;
                }
            }
            v14 = this.borderRadius;
            v15 = v14 != null ? v14.hasRoundedBorders() : false;
            if (!v15) break block27;
            v16 = this.computedBorderRadius;
            if (!(v16 != null ? v16.isUniform() : false)) {
                v17 = this.backgroundRenderPath;
                if (v17 != null) {
                    var3_3 = new float[8];
                    v18 = this.computedBorderRadius;
                    if (v18 != null && (v18 = v18.getTopLeft()) != null) {
                        var4_4 = v18.getHorizontal();
                        v19 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v19 = var3_3[0] = 0.0f;
                    }
                    if ((v20 = this.computedBorderRadius) != null && (v20 = v20.getTopLeft()) != null) {
                        var4_4 = v20.getVertical();
                        v21 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v21 = var3_3[1] = 0.0f;
                    }
                    if ((v22 = this.computedBorderRadius) != null && (v22 = v22.getTopRight()) != null) {
                        var4_4 = v22.getHorizontal();
                        v23 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v23 = var3_3[2] = 0.0f;
                    }
                    if ((v24 = this.computedBorderRadius) != null && (v24 = v24.getTopRight()) != null) {
                        var4_4 = v24.getVertical();
                        v25 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v25 = var3_3[3] = 0.0f;
                    }
                    if ((v26 = this.computedBorderRadius) != null && (v26 = v26.getBottomRight()) != null) {
                        var4_4 = v26.getHorizontal();
                        v27 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v27 = var3_3[4] = 0.0f;
                    }
                    if ((v28 = this.computedBorderRadius) != null && (v28 = v28.getBottomRight()) != null) {
                        var4_4 = v28.getVertical();
                        v29 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v29 = var3_3[5] = 0.0f;
                    }
                    if ((v30 = this.computedBorderRadius) != null && (v30 = v30.getBottomLeft()) != null) {
                        var4_4 = v30.getHorizontal();
                        v31 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v31 = var3_3[6] = 0.0f;
                    }
                    if ((v32 = this.computedBorderRadius) != null && (v32 = v32.getBottomLeft()) != null) {
                        var4_4 = v32.getVertical();
                        v33 = PixelUtil.INSTANCE.dpToPx(var4_4);
                    } else {
                        v33 = 0.0f;
                    }
                    var3_3[7] = v33;
                    v17.addRoundRect(this.backgroundRect, var3_3, Path.Direction.CW);
                }
            }
        }
    }
}

