/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.common.logging.FLog;
import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.build.ReactBuildConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/animated/FrameBasedAnimationDriver;", "Lcom/facebook/react/animated/AnimationDriver;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;)V", "startFrameTimeNanos", "", "frames", "", "toValue", "", "fromValue", "iterations", "", "currentLoop", "logCount", "resetConfig", "", "runAnimationStep", "frameTimeNanos", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nFrameBasedAnimationDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameBasedAnimationDriver.kt\ncom/facebook/react/animated/FrameBasedAnimationDriver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class FrameBasedAnimationDriver
extends AnimationDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long startFrameTimeNanos;
    @NotNull
    private double[] frames;
    private double toValue;
    private double fromValue;
    private int iterations;
    private int currentLoop;
    private int logCount;
    private static final double FRAME_TIME_MILLIS = 16.666666666666668;

    public FrameBasedAnimationDriver(@NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.startFrameTimeNanos = -1L;
        this.frames = new double[0];
        this.iterations = 1;
        this.currentLoop = 1;
        this.resetConfig(config);
    }

    @Override
    public void resetConfig(@NotNull ReadableMap config) {
        int numberOfFrames;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ReadableArray framesConfig = config.getArray("frames");
        if (framesConfig != null && this.frames.length != (numberOfFrames = framesConfig.size())) {
            int n = 0;
            double[] dArray = new double[numberOfFrames];
            FrameBasedAnimationDriver frameBasedAnimationDriver = this;
            while (n < numberOfFrames) {
                int n2 = n++;
                dArray[n2] = framesConfig.getDouble(n2);
            }
            frameBasedAnimationDriver.frames = dArray;
        }
        this.toValue = config.hasKey("toValue") && config.getType("toValue") == ReadableType.Number ? config.getDouble("toValue") : 0.0;
        this.iterations = config.hasKey("iterations") && config.getType("iterations") == ReadableType.Number ? config.getInt("iterations") : 1;
        this.currentLoop = 1;
        this.hasFinished = this.iterations == 0;
        this.startFrameTimeNanos = -1L;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        long timeFromStartMillis;
        int frameIndex;
        ValueAnimatedNode valueAnimatedNode = this.animatedValue;
        if (valueAnimatedNode == null) {
            boolean bl = false;
            String string = "Animated value should not be null";
            throw new IllegalArgumentException(string.toString());
        }
        ValueAnimatedNode animatedValue = valueAnimatedNode;
        if (this.startFrameTimeNanos < 0L) {
            this.startFrameTimeNanos = frameTimeNanos;
            if (this.currentLoop == 1) {
                this.fromValue = animatedValue.nodeValue;
            }
        }
        if ((frameIndex = (int)Math.round((double)(timeFromStartMillis = (frameTimeNanos - this.startFrameTimeNanos) / (long)1000000) / 16.666666666666668)) < 0) {
            String message = "Calculated frame index should never be lower than 0. Called with frameTimeNanos " + frameTimeNanos + " and mStartFrameTimeNanos " + this.startFrameTimeNanos;
            if (!(!ReactBuildConfig.DEBUG)) {
                boolean bl = false;
                String string = message;
                throw new IllegalStateException(string.toString());
            }
            if (this.logCount < 100) {
                FLog.w((String)"ReactNative", (String)message);
                int n = this.logCount;
                this.logCount = n + 1;
            }
            return;
        }
        if (this.hasFinished) {
            return;
        }
        double nextValue = 0.0;
        if (frameIndex >= this.frames.length - 1) {
            if (this.iterations == -1 || this.currentLoop < this.iterations) {
                nextValue = this.fromValue + this.frames[this.frames.length - 1] * (this.toValue - this.fromValue);
                this.startFrameTimeNanos = -1L;
                int n = this.currentLoop;
                this.currentLoop = n + 1;
            } else {
                nextValue = this.toValue;
                this.hasFinished = true;
            }
        } else {
            nextValue = this.fromValue + this.frames[frameIndex] * (this.toValue - this.fromValue);
        }
        animatedValue.nodeValue = nextValue;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/animated/FrameBasedAnimationDriver$Companion;", "", "<init>", "()V", "FRAME_TIME_MILLIS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

