/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import android.view.View;
import com.facebook.react.R;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\nH\u0007J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\nH\u0007J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0012\u0010#\u001a\u00020\n2\b\u0010$\u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005J\u001a\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010+\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/facebook/react/uimanager/events/PointerEventHelper;", "", "<init>", "()V", "POINTER_TYPE_TOUCH", "", "POINTER_TYPE_PEN", "POINTER_TYPE_MOUSE", "POINTER_TYPE_UNKNOWN", "X_FLAG_SUPPORTS_HOVER", "", "POINTER_CANCEL", "POINTER_DOWN", "POINTER_ENTER", "POINTER_LEAVE", "POINTER_MOVE", "POINTER_UP", "POINTER_OVER", "POINTER_OUT", "CLICK", "getButtons", "eventName", "pointerType", "buttonState", "getButtonChange", "lastButtonState", "currentButtonState", "getW3CPointerType", "toolType", "isListening", "", "view", "Landroid/view/View;", "event", "Lcom/facebook/react/uimanager/events/PointerEventHelper$EVENT;", "getEventCategory", "pointerEventType", "supportsHover", "motionEvent", "Landroid/view/MotionEvent;", "isExitEvent", "getPressure", "", "isBubblingEvent", "EVENT", "ReactAndroid_debug"})
public final class PointerEventHelper {
    @NotNull
    public static final PointerEventHelper INSTANCE = new PointerEventHelper();
    @NotNull
    public static final String POINTER_TYPE_TOUCH = "touch";
    @NotNull
    public static final String POINTER_TYPE_PEN = "pen";
    @NotNull
    public static final String POINTER_TYPE_MOUSE = "mouse";
    @NotNull
    public static final String POINTER_TYPE_UNKNOWN = "";
    public static final int X_FLAG_SUPPORTS_HOVER = 0x1000000;
    @NotNull
    public static final String POINTER_CANCEL = "topPointerCancel";
    @NotNull
    public static final String POINTER_DOWN = "topPointerDown";
    @NotNull
    public static final String POINTER_ENTER = "topPointerEnter";
    @NotNull
    public static final String POINTER_LEAVE = "topPointerLeave";
    @NotNull
    public static final String POINTER_MOVE = "topPointerMove";
    @NotNull
    public static final String POINTER_UP = "topPointerUp";
    @NotNull
    public static final String POINTER_OVER = "topPointerOver";
    @NotNull
    public static final String POINTER_OUT = "topPointerOut";
    @NotNull
    public static final String CLICK = "topClick";

    private PointerEventHelper() {
    }

    @JvmStatic
    public static final int getButtons(@Nullable String eventName, @NotNull String pointerType, int buttonState) {
        Intrinsics.checkNotNullParameter((Object)pointerType, (String)"pointerType");
        if (INSTANCE.isExitEvent(eventName)) {
            return 0;
        }
        if (Intrinsics.areEqual((Object)POINTER_TYPE_TOUCH, (Object)pointerType)) {
            return 1;
        }
        return buttonState;
    }

    @JvmStatic
    public static final int getButtonChange(@NotNull String pointerType, int lastButtonState, int currentButtonState) {
        Intrinsics.checkNotNullParameter((Object)pointerType, (String)"pointerType");
        if (Intrinsics.areEqual((Object)POINTER_TYPE_TOUCH, (Object)pointerType)) {
            return 0;
        }
        int changedMask = currentButtonState ^ lastButtonState;
        if (changedMask == 0) {
            return -1;
        }
        return switch (changedMask) {
            case 1 -> 0;
            case 4 -> 1;
            case 2 -> 2;
            case 8 -> 3;
            case 16 -> 4;
            default -> -1;
        };
    }

    @JvmStatic
    @NotNull
    public static final String getW3CPointerType(int toolType) {
        return switch (toolType) {
            case 1 -> POINTER_TYPE_TOUCH;
            case 2 -> POINTER_TYPE_PEN;
            case 3 -> POINTER_TYPE_MOUSE;
            default -> POINTER_TYPE_UNKNOWN;
        };
    }

    @JvmStatic
    public static final boolean isListening(@Nullable View view, @NotNull EVENT event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        if (view == null) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> true;
            default -> {
                Object var3_2 = view.getTag(R.id.pointer_events);
                Integer pointerEvents = var3_2 instanceof Integer ? (Integer)var3_2 : null;
                yield pointerEvents != null && (pointerEvents & 1 << event.ordinal()) != 0;
            }
        };
    }

    @JvmStatic
    public static final int getEventCategory(@Nullable String pointerEventType) {
        if (pointerEventType == null) {
            return 2;
        }
        return switch (pointerEventType) {
            case POINTER_CANCEL, POINTER_DOWN, POINTER_UP -> 3;
            case POINTER_ENTER, POINTER_OUT, POINTER_MOVE, POINTER_LEAVE, POINTER_OVER -> 4;
            default -> 2;
        };
    }

    public final boolean supportsHover(@NotNull MotionEvent motionEvent) {
        boolean supportsHoverFlag;
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
        boolean bl = supportsHoverFlag = (motionEvent.getFlags() & 0x1000000) != 0;
        if (supportsHoverFlag) {
            return true;
        }
        return motionEvent.isFromSource(8194);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isExitEvent(@Nullable String eventName) {
        String string2 = eventName;
        if (string2 == null) return false;
        switch (string2.hashCode()) {
            case 1343400710: {
                if (string2.equals(POINTER_OUT)) return true;
                return false;
            }
            case -1065042973: {
                if (string2.equals(POINTER_UP)) return true;
                return false;
            }
            case -1780335505: {
                if (!string2.equals(POINTER_LEAVE)) return false;
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    public static final double getPressure(int buttonState, @Nullable String eventName) {
        if (INSTANCE.isExitEvent(eventName)) {
            return 0.0;
        }
        boolean inActiveButtonState = buttonState != 0;
        return inActiveButtonState ? 0.5 : 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isBubblingEvent(@Nullable String eventName) {
        String string2 = eventName;
        if (string2 == null) return false;
        switch (string2.hashCode()) {
            case 1343400710: {
                if (string2.equals(POINTER_OUT)) return true;
                return false;
            }
            case 383186882: {
                if (string2.equals(POINTER_CANCEL)) return true;
                return false;
            }
            case -1065042973: {
                if (string2.equals(POINTER_UP)) return true;
                return false;
            }
            case -1304584214: {
                if (string2.equals(POINTER_DOWN)) return true;
                return false;
            }
            case -1304316135: {
                if (string2.equals(POINTER_MOVE)) return true;
                return false;
            }
            case -1304250340: {
                if (!string2.equals(POINTER_OVER)) return false;
                return true;
            }
        }
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0015\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/uimanager/events/PointerEventHelper$EVENT;", "", "<init>", "(Ljava/lang/String;I)V", "CANCEL", "CANCEL_CAPTURE", "CLICK", "CLICK_CAPTURE", "DOWN", "DOWN_CAPTURE", "ENTER", "ENTER_CAPTURE", "LEAVE", "LEAVE_CAPTURE", "MOVE", "MOVE_CAPTURE", "UP", "UP_CAPTURE", "OUT", "OUT_CAPTURE", "OVER", "OVER_CAPTURE", "ReactAndroid_debug"})
    public static final class EVENT
    extends Enum<EVENT> {
        public static final /* enum */ EVENT CANCEL = new EVENT();
        public static final /* enum */ EVENT CANCEL_CAPTURE = new EVENT();
        public static final /* enum */ EVENT CLICK = new EVENT();
        public static final /* enum */ EVENT CLICK_CAPTURE = new EVENT();
        public static final /* enum */ EVENT DOWN = new EVENT();
        public static final /* enum */ EVENT DOWN_CAPTURE = new EVENT();
        public static final /* enum */ EVENT ENTER = new EVENT();
        public static final /* enum */ EVENT ENTER_CAPTURE = new EVENT();
        public static final /* enum */ EVENT LEAVE = new EVENT();
        public static final /* enum */ EVENT LEAVE_CAPTURE = new EVENT();
        public static final /* enum */ EVENT MOVE = new EVENT();
        public static final /* enum */ EVENT MOVE_CAPTURE = new EVENT();
        public static final /* enum */ EVENT UP = new EVENT();
        public static final /* enum */ EVENT UP_CAPTURE = new EVENT();
        public static final /* enum */ EVENT OUT = new EVENT();
        public static final /* enum */ EVENT OUT_CAPTURE = new EVENT();
        public static final /* enum */ EVENT OVER = new EVENT();
        public static final /* enum */ EVENT OVER_CAPTURE = new EVENT();
        private static final /* synthetic */ EVENT[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EVENT[] values() {
            return (EVENT[])$VALUES.clone();
        }

        public static EVENT valueOf(String value) {
            return Enum.valueOf(EVENT.class, value);
        }

        @NotNull
        public static EnumEntries<EVENT> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eVENTArray = new EVENT[]{EVENT.CANCEL, EVENT.CANCEL_CAPTURE, EVENT.CLICK, EVENT.CLICK_CAPTURE, EVENT.DOWN, EVENT.DOWN_CAPTURE, EVENT.ENTER, EVENT.ENTER_CAPTURE, EVENT.LEAVE, EVENT.LEAVE_CAPTURE, EVENT.MOVE, EVENT.MOVE_CAPTURE, EVENT.UP, EVENT.UP_CAPTURE, EVENT.OUT, EVENT.OUT_CAPTURE, EVENT.OVER, EVENT.OVER_CAPTURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EVENT.values().length];
            try {
                nArray[EVENT.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.DOWN_CAPTURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.UP_CAPTURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.CANCEL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.CANCEL_CAPTURE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.CLICK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EVENT.CLICK_CAPTURE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

