/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.util.JsonReader;
import android.util.JsonToken;
import android.util.JsonWriter;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.JavascriptException;
import com.facebook.react.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

class JSDebuggerWebSocketClient
extends WebSocketListener {
    private static final String TAG = "JSDebuggerWebSocketClient";
    @Nullable
    private WebSocket mWebSocket;
    @Nullable
    private OkHttpClient mHttpClient;
    @Nullable
    private JSDebuggerCallback mConnectCallback;
    private final AtomicInteger mRequestID = new AtomicInteger();
    private final ConcurrentHashMap<Integer, JSDebuggerCallback> mCallbacks = new ConcurrentHashMap();

    JSDebuggerWebSocketClient() {
    }

    public void connect(String url, JSDebuggerCallback callback) {
        if (this.mHttpClient != null) {
            throw new IllegalStateException("JSDebuggerWebSocketClient is already initialized.");
        }
        this.mConnectCallback = callback;
        this.mHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        Request request = new Request.Builder().url(url).build();
        this.mHttpClient.newWebSocket(request, (WebSocketListener)this);
    }

    public void prepareJSRuntime(JSDebuggerCallback callback) {
        int requestID = this.mRequestID.getAndIncrement();
        this.mCallbacks.put(requestID, callback);
        try {
            StringWriter sw = new StringWriter();
            JsonWriter js = new JsonWriter((Writer)sw);
            js.beginObject().name("id").value((long)requestID).name("method").value("prepareJSRuntime").endObject().close();
            this.sendMessage(requestID, sw.toString());
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    public void loadBundle(String sourceURL, HashMap<String, String> injectedObjects, JSDebuggerCallback callback) {
        int requestID = this.mRequestID.getAndIncrement();
        this.mCallbacks.put(requestID, callback);
        try {
            StringWriter sw = new StringWriter();
            JsonWriter js = new JsonWriter((Writer)sw).beginObject().name("id").value((long)requestID).name("method").value("executeApplicationScript").name("url").value(sourceURL).name("inject").beginObject();
            for (String key : injectedObjects.keySet()) {
                js.name(key).value(injectedObjects.get(key));
            }
            js.endObject().endObject().close();
            this.sendMessage(requestID, sw.toString());
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    public void executeJSCall(String methodName, String jsonArgsArray, JSDebuggerCallback callback) {
        int requestID = this.mRequestID.getAndIncrement();
        this.mCallbacks.put(requestID, callback);
        try {
            StringWriter sw = new StringWriter();
            JsonWriter js = new JsonWriter((Writer)sw);
            js.beginObject().name("id").value((long)requestID).name("method").value(methodName);
            sw.append(",\"arguments\":").append(jsonArgsArray);
            js.endObject().close();
            this.sendMessage(requestID, sw.toString());
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    public void closeQuietly() {
        if (this.mWebSocket != null) {
            try {
                this.mWebSocket.close(1000, "End of session");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWebSocket = null;
        }
    }

    @VisibleForTesting
    void sendMessage(int requestID, String message) {
        if (this.mWebSocket == null) {
            this.triggerRequestFailure(requestID, new IllegalStateException("WebSocket connection no longer valid"));
            return;
        }
        try {
            this.mWebSocket.send(message);
        }
        catch (Exception e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    @VisibleForTesting
    void triggerRequestFailure(int requestID, Throwable cause) {
        JSDebuggerCallback callback = this.mCallbacks.get(requestID);
        if (callback != null) {
            this.mCallbacks.remove(requestID);
            callback.onFailure(cause);
        }
    }

    @VisibleForTesting
    void triggerRequestSuccess(int requestID, @Nullable String response) {
        JSDebuggerCallback callback = this.mCallbacks.get(requestID);
        if (callback != null) {
            this.mCallbacks.remove(requestID);
            callback.onSuccess(response);
        }
    }

    public void onMessage(@Nullable WebSocket webSocket, String text) {
        Integer replyID = null;
        try {
            JsonReader reader = new JsonReader((Reader)new StringReader(text));
            String result = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String field = reader.nextName();
                if (JsonToken.NULL == reader.peek()) {
                    reader.skipValue();
                    continue;
                }
                if ("replyID".equals(field)) {
                    replyID = reader.nextInt();
                    continue;
                }
                if ("result".equals(field)) {
                    result = reader.nextString();
                    continue;
                }
                if (!"error".equals(field)) continue;
                String error = reader.nextString();
                this.abort(error, new JavascriptException(error));
            }
            if (replyID != null) {
                this.triggerRequestSuccess(replyID, result);
            }
        }
        catch (IOException e) {
            if (replyID != null) {
                this.triggerRequestFailure(replyID, e);
            }
            this.abort("Parsing response message from websocket failed", e);
        }
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.abort("Websocket exception", t);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.mWebSocket = webSocket;
        ((JSDebuggerCallback)Assertions.assertNotNull((Object)this.mConnectCallback)).onSuccess(null);
        this.mConnectCallback = null;
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.mWebSocket = null;
    }

    @VisibleForTesting
    void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeQuietly();
        if (this.mConnectCallback != null) {
            this.mConnectCallback.onFailure(cause);
            this.mConnectCallback = null;
        }
        for (JSDebuggerCallback callback : this.mCallbacks.values()) {
            callback.onFailure(cause);
        }
        this.mCallbacks.clear();
    }

    public static interface JSDebuggerCallback {
        public void onSuccess(@Nullable String var1);

        public void onFailure(Throwable var1);
    }
}

