/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.interfaces.exceptionmanager.ReactJsExceptionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StackTraceHelper {
    public static final String COLUMN_KEY = "column";
    public static final String LINE_NUMBER_KEY = "lineNumber";
    public static final String FILE_KEY = "file";
    public static final String METHOD_NAME_KEY = "methodName";
    public static final String MESSAGE_KEY = "message";
    public static final String ORIGINAL_MESSAGE_KEY = "originalMessage";
    public static final String NAME_KEY = "name";
    public static final String COMPONENT_STACK_KEY = "componentStack";
    public static final String STACK_KEY = "stack";
    public static final String ID_KEY = "id";
    public static final String IS_FATAL_KEY = "isFatal";
    public static final String EXTRA_DATA_KEY = "extraData";
    private static final Pattern STACK_FRAME_PATTERN1 = Pattern.compile("^(?:(.*?)@)?(.*?)\\:([0-9]+)\\:([0-9]+)$");
    private static final Pattern STACK_FRAME_PATTERN2 = Pattern.compile("\\s*(?:at)\\s*(.+?)\\s*[@(](.*):([0-9]+):([0-9]+)[)]$");

    public static StackFrame[] convertJsStackTrace(@Nullable ReadableArray stack) {
        int size = stack != null ? stack.size() : 0;
        StackFrame[] result = new StackFrame[size];
        for (int i = 0; i < size; ++i) {
            ReadableType type = stack.getType(i);
            if (type == ReadableType.Map) {
                ReadableMap frame = stack.getMap(i);
                String methodName = frame.getString(METHOD_NAME_KEY);
                String fileName = frame.getString(FILE_KEY);
                boolean collapse = frame.hasKey("collapse") && !frame.isNull("collapse") && frame.getBoolean("collapse");
                int lineNumber = -1;
                if (frame.hasKey(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                    lineNumber = frame.getInt(LINE_NUMBER_KEY);
                }
                int columnNumber = -1;
                if (frame.hasKey(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                    columnNumber = frame.getInt(COLUMN_KEY);
                }
                result[i] = new StackFrameImpl(fileName, methodName, lineNumber, columnNumber, collapse);
                continue;
            }
            if (type != ReadableType.String) continue;
            result[i] = new StackFrameImpl(null, stack.getString(i), -1, -1);
        }
        return result;
    }

    public static StackFrame[] convertJsStackTrace(JSONArray stack) {
        int size = stack != null ? stack.length() : 0;
        StackFrame[] result = new StackFrame[size];
        try {
            for (int i = 0; i < size; ++i) {
                JSONObject frame = stack.getJSONObject(i);
                String methodName = frame.getString(METHOD_NAME_KEY);
                String fileName = frame.getString(FILE_KEY);
                int lineNumber = -1;
                if (frame.has(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                    lineNumber = frame.getInt(LINE_NUMBER_KEY);
                }
                int columnNumber = -1;
                if (frame.has(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                    columnNumber = frame.getInt(COLUMN_KEY);
                }
                boolean collapse = frame.has("collapse") && !frame.isNull("collapse") && frame.getBoolean("collapse");
                result[i] = new StackFrameImpl(fileName, methodName, lineNumber, columnNumber, collapse);
            }
        }
        catch (JSONException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static StackFrame[] convertJsStackTrace(String stack) {
        String[] stackTrace = stack.split("\n");
        StackFrame[] result = new StackFrame[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            Matcher matcher;
            Matcher matcher1 = STACK_FRAME_PATTERN1.matcher(stackTrace[i]);
            Matcher matcher2 = STACK_FRAME_PATTERN2.matcher(stackTrace[i]);
            if (matcher2.find()) {
                matcher = matcher2;
            } else if (matcher1.find()) {
                matcher = matcher1;
            } else {
                result[i] = new StackFrameImpl(null, stackTrace[i], -1, -1);
                continue;
            }
            result[i] = new StackFrameImpl(matcher.group(2), matcher.group(1) == null ? "(unknown)" : matcher.group(1), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
        }
        return result;
    }

    public static StackFrame[] convertJavaStackTrace(Throwable exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        StackFrame[] result = new StackFrame[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new StackFrameImpl(stackTrace[i].getClassName(), stackTrace[i].getFileName(), stackTrace[i].getMethodName(), stackTrace[i].getLineNumber(), -1);
        }
        return result;
    }

    public static String formatFrameSource(StackFrame frame) {
        StringBuilder lineInfo = new StringBuilder();
        lineInfo.append(frame.getFileName());
        int line = frame.getLine();
        if (line > 0) {
            lineInfo.append(":").append(line);
            int column = frame.getColumn();
            if (column > 0) {
                lineInfo.append(":").append(column);
            }
        }
        return lineInfo.toString();
    }

    public static String formatStackTrace(String title, StackFrame[] stack) {
        StringBuilder stackTrace = new StringBuilder();
        stackTrace.append(title).append("\n");
        for (StackFrame frame : stack) {
            stackTrace.append(frame.getMethod()).append("\n").append("    ").append(StackTraceHelper.formatFrameSource(frame)).append("\n");
        }
        return stackTrace.toString();
    }

    public static JavaOnlyMap convertProcessedError(ReactJsExceptionHandler.ProcessedError error) {
        List<ReactJsExceptionHandler.ProcessedError.StackFrame> frames = error.getStack();
        ArrayList<JavaOnlyMap> readableMapList = new ArrayList<JavaOnlyMap>();
        for (ReactJsExceptionHandler.ProcessedError.StackFrame frame : frames) {
            JavaOnlyMap map = new JavaOnlyMap();
            if (frame.getColumn() != null) {
                map.putDouble(COLUMN_KEY, frame.getColumn().intValue());
            }
            if (frame.getLineNumber() != null) {
                map.putDouble(LINE_NUMBER_KEY, frame.getLineNumber().intValue());
            }
            map.putString(FILE_KEY, frame.getFile());
            map.putString(METHOD_NAME_KEY, frame.getMethodName());
            readableMapList.add(map);
        }
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString(MESSAGE_KEY, error.getMessage());
        if (error.getOriginalMessage() != null) {
            data.putString(ORIGINAL_MESSAGE_KEY, error.getOriginalMessage());
        }
        if (error.getName() != null) {
            data.putString(NAME_KEY, error.getName());
        }
        if (error.getComponentStack() != null) {
            data.putString(COMPONENT_STACK_KEY, error.getComponentStack());
        }
        data.putArray(STACK_KEY, JavaOnlyArray.from(readableMapList));
        data.putInt(ID_KEY, error.getId());
        data.putBoolean(IS_FATAL_KEY, error.isFatal());
        data.putMap(EXTRA_DATA_KEY, error.getExtraData());
        return data;
    }

    public static class StackFrameImpl
    implements StackFrame {
        private final String mFile;
        private final String mMethod;
        private final int mLine;
        private final int mColumn;
        private final String mFileName;
        private final boolean mIsCollapsed;

        private StackFrameImpl(String file, String method, int line, int column, boolean isCollapsed) {
            this.mFile = file;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
            this.mFileName = file != null ? new File(file).getName() : "";
            this.mIsCollapsed = isCollapsed;
        }

        private StackFrameImpl(String file, String method, int line, int column) {
            this(file, method, line, column, false);
        }

        private StackFrameImpl(String file, String fileName, String method, int line, int column) {
            this.mFile = file;
            this.mFileName = fileName;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
            this.mIsCollapsed = false;
        }

        @Override
        public String getFile() {
            return this.mFile;
        }

        @Override
        public String getMethod() {
            return this.mMethod;
        }

        @Override
        public int getLine() {
            return this.mLine;
        }

        @Override
        public int getColumn() {
            return this.mColumn;
        }

        @Override
        public String getFileName() {
            return this.mFileName;
        }

        @Override
        public boolean isCollapsed() {
            return this.mIsCollapsed;
        }

        @Override
        public JSONObject toJSON() {
            return new JSONObject(MapBuilder.of(StackTraceHelper.FILE_KEY, this.getFile(), StackTraceHelper.METHOD_NAME_KEY, this.getMethod(), StackTraceHelper.LINE_NUMBER_KEY, this.getLine(), StackTraceHelper.COLUMN_KEY, this.getColumn(), "collapse", this.isCollapsed()));
        }
    }
}

