/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.devsupport.LogBoxDialog;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.util.RNLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/devsupport/LogBoxDialogSurfaceDelegate;", "Lcom/facebook/react/common/SurfaceDelegate;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "<init>", "(Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "reactRootView", "Landroid/view/View;", "dialog", "Lcom/facebook/react/devsupport/LogBoxDialog;", "createContentView", "", "appKey", "", "isContentViewReady", "", "destroyContentView", "show", "hide", "isShowing", "ReactAndroid_release"})
public final class LogBoxDialogSurfaceDelegate
implements SurfaceDelegate {
    @NotNull
    private final DevSupportManager devSupportManager;
    @Nullable
    private View reactRootView;
    @Nullable
    private LogBoxDialog dialog;

    public LogBoxDialogSurfaceDelegate(@NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        this.devSupportManager = devSupportManager;
    }

    @Override
    public void createContentView(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Assertions.assertCondition((boolean)Intrinsics.areEqual((Object)appKey, (Object)"LogBox"), (String)"This surface manager can only create LogBox React application");
        this.reactRootView = this.devSupportManager.createRootView("LogBox");
        if (this.reactRootView == null) {
            RNLog.e("Unable to launch logbox because react was unable to create the root view");
        }
    }

    @Override
    public boolean isContentViewReady() {
        return this.reactRootView != null;
    }

    @Override
    public void destroyContentView() {
        if (this.reactRootView != null) {
            this.devSupportManager.destroyRootView(this.reactRootView);
            this.reactRootView = null;
        }
    }

    @Override
    public void show() {
        block2: {
            if (this.isShowing() || !this.isContentViewReady()) {
                return;
            }
            Activity context = this.devSupportManager.getCurrentActivity();
            if (context == null || context.isFinishing()) {
                RNLog.e("Unable to launch logbox because react activity is not available, here is the error that logbox would've displayed: ");
                return;
            }
            LogBoxDialog logBoxDialog = this.dialog = new LogBoxDialog(context, this.reactRootView);
            if (logBoxDialog == null) break block2;
            LogBoxDialog dialog = logBoxDialog;
            boolean bl = false;
            dialog.setCancelable(false);
            dialog.show();
        }
    }

    @Override
    public void hide() {
        if (this.isShowing()) {
            LogBoxDialog logBoxDialog = this.dialog;
            if (logBoxDialog != null) {
                logBoxDialog.dismiss();
            }
        }
        View view = this.reactRootView;
        ViewGroup viewGroup = (ViewGroup)(view != null ? view.getParent() : null);
        if (viewGroup != null) {
            viewGroup.removeView(this.reactRootView);
        }
        this.dialog = null;
    }

    @Override
    public boolean isShowing() {
        LogBoxDialog logBoxDialog = this.dialog;
        return logBoxDialog != null ? logBoxDialog.isShowing() : false;
    }
}

