/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.safeareaview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.UiThread;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0014J0\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0014J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/views/safeareaview/ReactSafeAreaView;", "Landroid/view/ViewGroup;", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "(Lcom/facebook/react/uimanager/ThemedReactContext;)V", "getReactContext", "()Lcom/facebook/react/uimanager/ThemedReactContext;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper$ReactAndroid_release", "()Lcom/facebook/react/uimanager/StateWrapper;", "setStateWrapper$ReactAndroid_release", "(Lcom/facebook/react/uimanager/StateWrapper;)V", "onAttachedToWindow", "", "onLayout", "p0", "", "p1", "", "p2", "p3", "p4", "updateState", "insets", "Landroidx/core/graphics/Insets;", "ReactAndroid_release"})
public final class ReactSafeAreaView
extends ViewGroup {
    @NotNull
    private final ThemedReactContext reactContext;
    @Nullable
    private StateWrapper stateWrapper;

    public ReactSafeAreaView(@NotNull ThemedReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super((Context)reactContext);
        this.reactContext = reactContext;
    }

    @NotNull
    public final ThemedReactContext getReactContext() {
        return this.reactContext;
    }

    @Nullable
    public final StateWrapper getStateWrapper$ReactAndroid_release() {
        return this.stateWrapper;
    }

    public final void setStateWrapper$ReactAndroid_release(@Nullable StateWrapper stateWrapper) {
        this.stateWrapper = stateWrapper;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (arg_0, arg_1) -> ReactSafeAreaView.onAttachedToWindow$lambda$0(this, arg_0, arg_1));
        this.requestApplyInsets();
    }

    protected void onLayout(boolean p0, int p1, int p2, int p3, int p4) {
    }

    @UiThread
    private final void updateState(Insets insets) {
        StateWrapper stateWrapper = this.stateWrapper;
        if (stateWrapper != null) {
            WritableNativeMap writableNativeMap;
            StateWrapper stateWrapper2 = stateWrapper;
            boolean bl = false;
            WritableNativeMap $this$updateState_u24lambda_u242_u24lambda_u241 = writableNativeMap = new WritableNativeMap();
            boolean bl2 = false;
            $this$updateState_u24lambda_u242_u24lambda_u241.putDouble("left", PixelUtil.INSTANCE.pxToDp(insets.left));
            $this$updateState_u24lambda_u242_u24lambda_u241.putDouble("top", PixelUtil.INSTANCE.pxToDp(insets.top));
            $this$updateState_u24lambda_u242_u24lambda_u241.putDouble("bottom", PixelUtil.INSTANCE.pxToDp(insets.bottom));
            $this$updateState_u24lambda_u242_u24lambda_u241.putDouble("right", PixelUtil.INSTANCE.pxToDp(insets.right));
            stateWrapper2.updateState($this$updateState_u24lambda_u242_u24lambda_u241);
        } else {
            ThemedReactContext themedReactContext = this.reactContext;
            this.reactContext.runOnNativeModulesQueueThread(new GuardedRunnable(this, insets, themedReactContext){
                final /* synthetic */ ReactSafeAreaView this$0;
                final /* synthetic */ Insets $insets;
                {
                    this.this$0 = $receiver;
                    this.$insets = $insets;
                    super($super_call_param$1);
                }

                public void runGuarded() {
                    UIManagerModule uIManagerModule = this.this$0.getReactContext().getReactApplicationContext().getNativeModule(UIManagerModule.class);
                    if (uIManagerModule != null) {
                        uIManagerModule.updateInsetsPadding(this.this$0.getId(), this.$insets.top, this.$insets.left, this.$insets.bottom, this.$insets.right);
                    }
                }
            });
        }
    }

    private static final WindowInsetsCompat onAttachedToWindow$lambda$0(ReactSafeAreaView this$0, View view, WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)view, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        Insets insets2 = insets;
        this$0.updateState(insets2);
        return WindowInsetsCompat.CONSUMED;
    }
}

