/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.OverScroller;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001:\bVWXYZ[\\]B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0007J+\u0010\u001e\u001a\u00020\u001c\"\u0014\b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001fH\u0007\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\"H\u0007J%\u0010&\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001fH\u0007\u00a2\u0006\u0002\u0010$J5\u0010'\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0007\u00a2\u0006\u0002\u0010+J-\u0010,\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/JG\u0010,\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\b\b\u0002\u00100\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u00101J5\u0010,\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0007\u00a2\u0006\u0002\u0010+J5\u00102\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u00103J%\u00104\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001f*\u0004\u0018\u00010!*\u00020\"2\u0006\u0010#\u001a\u0002H\u001fH\u0007\u00a2\u0006\u0002\u0010$J+\u00105\u001a\u00020\u001c\"\u0014\b\u0000\u0010\u001f*\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001fH\u0007\u00a2\u0006\u0002\u0010$J\u0012\u00108\u001a\u00020\u000f2\b\u00109\u001a\u0004\u0018\u00010:H\u0007JC\u0010;\u001a\u00020\u000f\"\u0014\b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u000106*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010?J\u0012\u0010@\u001a\u00020\u000f2\b\u0010A\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010B\u001a\u00020\u000f2\b\u0010C\u001a\u0004\u0018\u00010\u0004H\u0007JK\u0010D\u001a\u00020E\"\u0014\b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u000106*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010JJ/\u0010K\u001a\u00020\u001c\"\u001a\b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f\u00a2\u0006\u0002\u0010$J\u0010\u0010L\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0007JA\u0010M\u001a\u00020\u001c\"\u001a\b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010N\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u00103J1\u0010P\u001a\u00020\u001c\"\u001a\b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001fH\u0007\u00a2\u0006\u0002\u0010$J9\u0010P\u001a\u00020\u001c\"\u0014\b\u0000\u0010\u001f*\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010Q\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020\u000f\u00a2\u0006\u0002\u00103JG\u0010S\u001a\u00020\u001c\" \b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u00010!*\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0007\u00a2\u0006\u0002\u0010+JO\u0010S\u001a\u00020\u001c\" \b\u0000\u0010\u001f*\u0004\u0018\u00010 *\u0004\u0018\u00010!*\u0004\u0018\u000106*\u0004\u0018\u000107*\u00020\"2\u0006\u0010#\u001a\u0002H\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010T\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010UR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper;", "", "()V", "AUTO", "", "CONTENT_OFFSET_LEFT", "CONTENT_OFFSET_TOP", "DEBUG_MODE", "", "MOMENTUM_DELAY", "", "OVER_SCROLL_ALWAYS", "OVER_SCROLL_NEVER", "SCROLL_AWAY_PADDING_TOP", "SMOOTH_SCROLL_DURATION", "", "SNAP_ALIGNMENT_CENTER", "SNAP_ALIGNMENT_DISABLED", "SNAP_ALIGNMENT_END", "SNAP_ALIGNMENT_START", "TAG", "kotlin.jvm.PlatformType", "scrollListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/ref/WeakReference;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ScrollListener;", "smoothScrollDurationInitialized", "addScrollListener", "", "listener", "dispatchMomentumEndOnAnimationEnd", "T", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasFlingAnimator;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollEventThrottle;", "Landroid/view/ViewGroup;", "scrollView", "(Landroid/view/ViewGroup;)V", "emitLayoutEvent", "emitScrollBeginDragEvent", "emitScrollEndDragEvent", "xVelocity", "", "yVelocity", "(Landroid/view/ViewGroup;FF)V", "emitScrollEvent", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "(Landroid/view/ViewGroup;Lcom/facebook/react/views/scroll/ScrollEventType;)V", "experimental_isSynchronous", "(Landroid/view/ViewGroup;Lcom/facebook/react/views/scroll/ScrollEventType;FFZ)V", "emitScrollMomentumBeginEvent", "(Landroid/view/ViewGroup;II)V", "emitScrollMomentumEndEvent", "forceUpdateState", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollState;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasStateWrapper;", "getDefaultScrollAnimationDuration", "context", "Landroid/content/Context;", "getNextFlingStartValue", "currentValue", "postAnimationValue", "velocity", "(Landroid/view/ViewGroup;III)I", "parseOverScrollMode", "jsOverScrollMode", "parseSnapToAlignment", "alignment", "predictFinalScrollPosition", "Landroid/graphics/Point;", "velocityX", "velocityY", "maximumOffsetX", "maximumOffsetY", "(Landroid/view/ViewGroup;IIII)Landroid/graphics/Point;", "registerFlingAnimator", "removeScrollListener", "smoothScrollTo", "x", "y", "updateFabricScrollState", "scrollX", "scrollY", "updateStateOnScrollChanged", "experimental_synchronous", "(Landroid/view/ViewGroup;FFZ)V", "HasFlingAnimator", "HasScrollEventThrottle", "HasScrollState", "HasSmoothScroll", "HasStateWrapper", "OverScrollerDurationGetter", "ReactScrollViewScrollState", "ScrollListener", "ReactAndroid_release"})
public final class ReactScrollViewHelper {
    @NotNull
    public static final ReactScrollViewHelper INSTANCE = new ReactScrollViewHelper();
    private static final String TAG = ReactHorizontalScrollView.class.getSimpleName();
    private static final boolean DEBUG_MODE;
    @NotNull
    private static final String CONTENT_OFFSET_LEFT = "contentOffsetLeft";
    @NotNull
    private static final String CONTENT_OFFSET_TOP = "contentOffsetTop";
    @NotNull
    private static final String SCROLL_AWAY_PADDING_TOP = "scrollAwayPaddingTop";
    public static final long MOMENTUM_DELAY = 20L;
    @NotNull
    public static final String OVER_SCROLL_ALWAYS = "always";
    @NotNull
    public static final String AUTO = "auto";
    @NotNull
    public static final String OVER_SCROLL_NEVER = "never";
    public static final int SNAP_ALIGNMENT_DISABLED = 0;
    public static final int SNAP_ALIGNMENT_START = 1;
    public static final int SNAP_ALIGNMENT_CENTER = 2;
    public static final int SNAP_ALIGNMENT_END = 3;
    @NotNull
    private static final CopyOnWriteArrayList<WeakReference<ScrollListener>> scrollListeners;
    private static int SMOOTH_SCROLL_DURATION;
    private static boolean smoothScrollDurationInitialized;

    private ReactScrollViewHelper() {
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollEvent(T scrollView, float xVelocity, float yVelocity) {
        ReactScrollViewHelper.emitScrollEvent$default(INSTANCE, scrollView, ScrollEventType.SCROLL, xVelocity, yVelocity, false, 16, null);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollBeginDragEvent(T scrollView) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.BEGIN_DRAG);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollEndDragEvent(T scrollView, float xVelocity, float yVelocity) {
        ReactScrollViewHelper.emitScrollEvent$default(INSTANCE, scrollView, ScrollEventType.END_DRAG, xVelocity, yVelocity, false, 16, null);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollMomentumBeginEvent(T scrollView, int xVelocity, int yVelocity) {
        ReactScrollViewHelper.emitScrollEvent$default(INSTANCE, scrollView, ScrollEventType.MOMENTUM_BEGIN, xVelocity, yVelocity, false, 16, null);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollMomentumEndEvent(T scrollView) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_END);
    }

    private final <T extends ViewGroup> void emitScrollEvent(T scrollView, ScrollEventType scrollEventType) {
        ReactScrollViewHelper.emitScrollEvent$default(this, scrollView, scrollEventType, 0.0f, 0.0f, false, 16, null);
    }

    private final <T extends ViewGroup> void emitScrollEvent(T scrollView, ScrollEventType scrollEventType, float xVelocity, float yVelocity, boolean experimental_isSynchronous) {
        long now = System.currentTimeMillis();
        if ((long)((HasScrollEventThrottle)scrollView).getScrollEventThrottle() >= Math.max(17L, now - ((HasScrollEventThrottle)scrollView).getLastScrollDispatchTime())) {
            return;
        }
        View view = scrollView.getChildAt(0);
        if (view == null) {
            return;
        }
        View contentView = view;
        for (WeakReference<ScrollListener> scrollListener : scrollListeners) {
            ScrollListener scrollListener2 = (ScrollListener)scrollListener.get();
            if (scrollListener2 == null) continue;
            scrollListener2.onScroll(scrollView, scrollEventType, xVelocity, yVelocity);
        }
        Context context = scrollView.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
        ReactContext reactContext = (ReactContext)context;
        int surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, scrollView.getId());
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent(ScrollEvent.Companion.obtain(surfaceId, scrollView.getId(), scrollEventType, scrollView.getScrollX(), scrollView.getScrollY(), xVelocity, yVelocity, contentView.getWidth(), contentView.getHeight(), scrollView.getWidth(), scrollView.getHeight(), experimental_isSynchronous));
            ((HasScrollEventThrottle)scrollView).setLastScrollDispatchTime(now);
        }
    }

    static /* synthetic */ void emitScrollEvent$default(ReactScrollViewHelper reactScrollViewHelper, ViewGroup viewGroup, ScrollEventType scrollEventType, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        reactScrollViewHelper.emitScrollEvent(viewGroup, scrollEventType, f, f2, bl);
    }

    @JvmStatic
    public static final void emitLayoutEvent(@NotNull ViewGroup scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        for (WeakReference<ScrollListener> scrollListener : scrollListeners) {
            ScrollListener scrollListener2 = (ScrollListener)scrollListener.get();
            if (scrollListener2 == null) continue;
            scrollListener2.onLayout(scrollView);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final int parseOverScrollMode(@Nullable String jsOverScrollMode) {
        if (jsOverScrollMode == null) return 1;
        switch (jsOverScrollMode.hashCode()) {
            case -1414557169: {
                if (jsOverScrollMode.equals(OVER_SCROLL_ALWAYS)) return 0;
                break;
            }
            case 104712844: {
                if (jsOverScrollMode.equals(OVER_SCROLL_NEVER)) return 2;
                break;
            }
            case 3005871: {
                if (!jsOverScrollMode.equals(AUTO)) break;
                return 1;
            }
        }
        FLog.w((String)"ReactNative", (String)("wrong overScrollMode: " + jsOverScrollMode));
        return 1;
    }

    @JvmStatic
    public static final int parseSnapToAlignment(@Nullable String alignment) {
        int n;
        if (alignment == null) {
            n = 0;
        } else if (StringsKt.equals((String)"start", (String)alignment, (boolean)true)) {
            n = 1;
        } else if (StringsKt.equals((String)"center", (String)alignment, (boolean)true)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)"end", (Object)alignment)) {
            n = 3;
        } else {
            FLog.w((String)"ReactNative", (String)("wrong snap alignment value: " + alignment));
            n = 0;
        }
        return n;
    }

    @JvmStatic
    public static final int getDefaultScrollAnimationDuration(@Nullable Context context) {
        if (!smoothScrollDurationInitialized) {
            smoothScrollDurationInitialized = true;
            try {
                OverScrollerDurationGetter overScrollerDurationGetter = new OverScrollerDurationGetter(context);
                SMOOTH_SCROLL_DURATION = overScrollerDurationGetter.getScrollAnimationDuration();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SMOOTH_SCROLL_DURATION;
    }

    @JvmStatic
    public static final void addScrollListener(@NotNull ScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        scrollListeners.add(new WeakReference<ScrollListener>(listener));
    }

    @JvmStatic
    public static final void removeScrollListener(@NotNull ScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        scrollListeners.remove(new WeakReference<ScrollListener>(listener));
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollState> void smoothScrollTo(T scrollView, int x, int y) {
        ValueAnimator flingAnimator;
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"smoothScrollTo[%d] x %d y %d", (Object)scrollView.getId(), (Object)x, (Object)y);
        }
        if ((flingAnimator = ((HasFlingAnimator)scrollView).getFlingAnimator()).getListeners() == null || flingAnimator.getListeners().size() == 0) {
            INSTANCE.registerFlingAnimator(scrollView);
        }
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        scrollState.setFinalAnimatedPositionScroll(x, y);
        int scrollX = scrollView.getScrollX();
        int scrollY = scrollView.getScrollY();
        if (scrollX != x) {
            ((HasFlingAnimator)scrollView).startFlingAnimator(scrollX, x);
        }
        if (scrollY != y) {
            ((HasFlingAnimator)scrollView).startFlingAnimator(scrollY, y);
        }
        if (ReactNativeFeatureFlags.fixIncorrectScrollViewStateUpdateOnAndroid()) {
            INSTANCE.updateFabricScrollState(scrollView, x, y);
        }
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollState> int getNextFlingStartValue(T scrollView, int currentValue, int postAnimationValue, int velocity) {
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        int velocityDirectionMask = velocity != 0 ? velocity / Math.abs(velocity) : 0;
        boolean isMovingTowardsAnimatedValue = velocityDirectionMask * (postAnimationValue - currentValue) > 0;
        return !scrollState.isFinished() || scrollState.isCanceled() && isMovingTowardsAnimatedValue ? postAnimationValue : currentValue;
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollState> void updateFabricScrollState(T scrollView) {
        INSTANCE.updateFabricScrollState(scrollView, scrollView.getScrollX(), scrollView.getScrollY());
    }

    public final <T extends ViewGroup & HasStateWrapper> void updateFabricScrollState(T scrollView, int scrollX, int scrollY) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"updateFabricScrollState[%d] scrollX %d scrollY %d", (Object)scrollView.getId(), (Object)scrollX, (Object)scrollY);
        }
        if (ViewUtil.getUIManagerType(scrollView.getId()) == 1) {
            return;
        }
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        if (scrollState.getLastStateUpdateScroll().equals(scrollX, scrollY)) {
            return;
        }
        scrollState.setLastStateUpdateScroll(scrollX, scrollY);
        ReactScrollViewHelper.forceUpdateState(scrollView);
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasStateWrapper> void forceUpdateState(T scrollView) {
        StateWrapper stateWrapper;
        int fabricScrollX;
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        int scrollAwayPaddingTop = scrollState.getScrollAwayPaddingTop();
        Point scrollPos = scrollState.getLastStateUpdateScroll();
        int scrollX = scrollPos.x;
        int scrollY = scrollPos.y;
        int layoutDirection = scrollState.getLayoutDirection();
        if (layoutDirection == 1) {
            View child;
            View view = child = scrollView.getChildAt(0);
            int contentWidth = view != null ? view.getWidth() : 0;
            v1 = -(contentWidth - scrollX - scrollView.getWidth());
        } else {
            v1 = fabricScrollX = scrollX;
        }
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"updateFabricScrollState[%d] scrollX %d scrollY %d fabricScrollX %d", (Object)scrollView.getId(), (Object)scrollX, (Object)scrollY, (Object)fabricScrollX);
        }
        if ((stateWrapper = ((HasStateWrapper)scrollView).getStateWrapper()) != null) {
            WritableMap newStateData = new WritableNativeMap();
            newStateData.putDouble(CONTENT_OFFSET_LEFT, PixelUtil.toDIPFromPixel(scrollX));
            newStateData.putDouble(CONTENT_OFFSET_TOP, PixelUtil.toDIPFromPixel(scrollY));
            newStateData.putDouble(SCROLL_AWAY_PADDING_TOP, PixelUtil.toDIPFromPixel(scrollAwayPaddingTop));
            stateWrapper.updateState(newStateData);
        }
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollEventThrottle & HasStateWrapper> void updateStateOnScrollChanged(T scrollView, float xVelocity, float yVelocity) {
        ReactScrollViewHelper.updateStateOnScrollChanged(scrollView, xVelocity, yVelocity, false);
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollEventThrottle & HasStateWrapper> void updateStateOnScrollChanged(T scrollView, float xVelocity, float yVelocity, boolean experimental_synchronous) {
        INSTANCE.updateFabricScrollState(scrollView, scrollView.getScrollX(), scrollView.getScrollY());
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.SCROLL, xVelocity, yVelocity, experimental_synchronous);
    }

    public final <T extends ViewGroup & HasScrollState> void registerFlingAnimator(T scrollView) {
        ((HasFlingAnimator)scrollView).getFlingAnimator().addListener(new Animator.AnimatorListener(scrollView){
            final /* synthetic */ T $scrollView;
            {
                this.$scrollView = $scrollView;
            }

            public void onAnimationStart(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ReactScrollViewScrollState scrollState = ((HasScrollState)this.$scrollView).getReactScrollViewScrollState();
                scrollState.setCanceled(false);
                scrollState.setFinished(false);
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ((HasScrollState)this.$scrollView).getReactScrollViewScrollState().setFinished(true);
                ReactScrollViewHelper.updateFabricScrollState(this.$scrollView);
            }

            public void onAnimationCancel(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ((HasScrollState)this.$scrollView).getReactScrollViewScrollState().setCanceled(true);
            }

            public void onAnimationRepeat(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            }
        });
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollEventThrottle> void dispatchMomentumEndOnAnimationEnd(T scrollView) {
        ((HasFlingAnimator)scrollView).getFlingAnimator().addListener(new Animator.AnimatorListener(scrollView){
            final /* synthetic */ T $scrollView;
            {
                this.$scrollView = $scrollView;
            }

            public void onAnimationStart(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ReactScrollViewHelper.emitScrollMomentumEndEvent(this.$scrollView);
                animator.removeListener((Animator.AnimatorListener)this);
            }

            public void onAnimationCancel(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ReactScrollViewHelper.emitScrollMomentumEndEvent(this.$scrollView);
                animator.removeListener((Animator.AnimatorListener)this);
            }

            public void onAnimationRepeat(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final <T extends ViewGroup & HasScrollState> Point predictFinalScrollPosition(T scrollView, int velocityX, int velocityY, int maximumOffsetX, int maximumOffsetY) {
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        OverScroller scroller = new OverScroller(scrollView.getContext());
        scroller.setFriction(1.0f - scrollState.getDecelerationRate());
        int width = scrollView.getWidth() - scrollView.getPaddingStart() - scrollView.getPaddingEnd();
        int height = scrollView.getHeight() - scrollView.getPaddingBottom() - scrollView.getPaddingTop();
        Point finalAnimatedPositionScroll = scrollState.getFinalAnimatedPositionScroll();
        scroller.fling(ReactScrollViewHelper.getNextFlingStartValue(scrollView, scrollView.getScrollX(), finalAnimatedPositionScroll.x, velocityX), ReactScrollViewHelper.getNextFlingStartValue(scrollView, scrollView.getScrollY(), finalAnimatedPositionScroll.y, velocityY), velocityX, velocityY, 0, maximumOffsetX, 0, maximumOffsetY, width / 2, height / 2);
        return new Point(scroller.getFinalX(), scroller.getFinalY());
    }

    static {
        scrollListeners = new CopyOnWriteArrayList();
        SMOOTH_SCROLL_DURATION = 250;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasFlingAnimator;", "", "getFlingAnimator", "Landroid/animation/ValueAnimator;", "getFlingExtrapolatedDistance", "", "velocity", "startFlingAnimator", "", "start", "end", "ReactAndroid_release"})
    public static interface HasFlingAnimator {
        public void startFlingAnimator(int var1, int var2);

        @NotNull
        public ValueAnimator getFlingAnimator();

        public int getFlingExtrapolatedDistance(int var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollEventThrottle;", "", "lastScrollDispatchTime", "", "getLastScrollDispatchTime", "()J", "setLastScrollDispatchTime", "(J)V", "scrollEventThrottle", "", "getScrollEventThrottle", "()I", "setScrollEventThrottle", "(I)V", "ReactAndroid_release"})
    public static interface HasScrollEventThrottle {
        public int getScrollEventThrottle();

        public void setScrollEventThrottle(int var1);

        public long getLastScrollDispatchTime();

        public void setLastScrollDispatchTime(long var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollState;", "", "reactScrollViewScrollState", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ReactScrollViewScrollState;", "getReactScrollViewScrollState", "()Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ReactScrollViewScrollState;", "ReactAndroid_release"})
    public static interface HasScrollState {
        @NotNull
        public ReactScrollViewScrollState getReactScrollViewScrollState();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasSmoothScroll;", "", "reactSmoothScrollTo", "", "x", "", "y", "scrollToPreservingMomentum", "ReactAndroid_release"})
    public static interface HasSmoothScroll {
        public void reactSmoothScrollTo(int var1, int var2);

        public void scrollToPreservingMomentum(int var1, int var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasStateWrapper;", "", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper", "()Lcom/facebook/react/uimanager/StateWrapper;", "ReactAndroid_release"})
    public static interface HasStateWrapper {
        @Nullable
        public StateWrapper getStateWrapper();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$OverScrollerDurationGetter;", "Landroid/widget/OverScroller;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentScrollAnimationDuration", "", "scrollAnimationDuration", "getScrollAnimationDuration", "()I", "startScroll", "", "startX", "startY", "dx", "dy", "duration", "ReactAndroid_release"})
    private static final class OverScrollerDurationGetter
    extends OverScroller {
        private int currentScrollAnimationDuration = 250;

        public OverScrollerDurationGetter(@Nullable Context context) {
            super(context);
        }

        public final int getScrollAnimationDuration() {
            super.startScroll(0, 0, 0, 0);
            return this.currentScrollAnimationDuration;
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            this.currentScrollAnimationDuration = duration;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u0004\u00a8\u0006#"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ReactScrollViewScrollState;", "", "layoutDirection", "", "(I)V", "decelerationRate", "", "getDecelerationRate", "()F", "setDecelerationRate", "(F)V", "finalAnimatedPositionScroll", "Landroid/graphics/Point;", "getFinalAnimatedPositionScroll", "()Landroid/graphics/Point;", "isCanceled", "", "()Z", "setCanceled", "(Z)V", "isFinished", "setFinished", "lastStateUpdateScroll", "getLastStateUpdateScroll", "getLayoutDirection", "()I", "scrollAwayPaddingTop", "getScrollAwayPaddingTop", "setScrollAwayPaddingTop", "setFinalAnimatedPositionScroll", "finalAnimatedPositionScrollX", "finalAnimatedPositionScrollY", "setLastStateUpdateScroll", "lastStateUpdateScrollX", "lastStateUpdateScrollY", "ReactAndroid_release"})
    public static final class ReactScrollViewScrollState {
        private final int layoutDirection;
        @NotNull
        private final Point finalAnimatedPositionScroll;
        private int scrollAwayPaddingTop;
        @NotNull
        private final Point lastStateUpdateScroll;
        private boolean isCanceled;
        private boolean isFinished;
        private float decelerationRate;

        public ReactScrollViewScrollState(int layoutDirection) {
            this.layoutDirection = layoutDirection;
            this.finalAnimatedPositionScroll = new Point();
            this.lastStateUpdateScroll = new Point(-1, -1);
            this.isFinished = true;
            this.decelerationRate = 0.985f;
        }

        public final int getLayoutDirection() {
            return this.layoutDirection;
        }

        @NotNull
        public final Point getFinalAnimatedPositionScroll() {
            return this.finalAnimatedPositionScroll;
        }

        public final int getScrollAwayPaddingTop() {
            return this.scrollAwayPaddingTop;
        }

        public final void setScrollAwayPaddingTop(int n) {
            this.scrollAwayPaddingTop = n;
        }

        @NotNull
        public final Point getLastStateUpdateScroll() {
            return this.lastStateUpdateScroll;
        }

        public final boolean isCanceled() {
            return this.isCanceled;
        }

        public final void setCanceled(boolean bl) {
            this.isCanceled = bl;
        }

        public final boolean isFinished() {
            return this.isFinished;
        }

        public final void setFinished(boolean bl) {
            this.isFinished = bl;
        }

        public final float getDecelerationRate() {
            return this.decelerationRate;
        }

        public final void setDecelerationRate(float f) {
            this.decelerationRate = f;
        }

        @NotNull
        public final ReactScrollViewScrollState setFinalAnimatedPositionScroll(int finalAnimatedPositionScrollX, int finalAnimatedPositionScrollY) {
            this.finalAnimatedPositionScroll.set(finalAnimatedPositionScrollX, finalAnimatedPositionScrollY);
            return this;
        }

        @NotNull
        public final ReactScrollViewScrollState setLastStateUpdateScroll(int lastStateUpdateScrollX, int lastStateUpdateScrollY) {
            this.lastStateUpdateScroll.set(lastStateUpdateScrollX, lastStateUpdateScrollY);
            return this;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J,\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ScrollListener;", "", "onLayout", "", "scrollView", "Landroid/view/ViewGroup;", "onScroll", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "xVelocity", "", "yVelocity", "ReactAndroid_release"})
    public static interface ScrollListener {
        public void onScroll(@Nullable ViewGroup var1, @Nullable ScrollEventType var2, float var3, float var4);

        public void onLayout(@Nullable ViewGroup var1);
    }
}

