/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.internal.span;

import android.graphics.Paint;
import android.text.style.LineHeightSpan;
import com.facebook.react.views.text.internal.span.ReactSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/views/text/internal/span/CustomLineHeightSpan;", "Landroid/text/style/LineHeightSpan;", "Lcom/facebook/react/views/text/internal/span/ReactSpan;", "height", "", "(F)V", "lineHeight", "", "getLineHeight", "()I", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "ReactAndroid_debug"})
public final class CustomLineHeightSpan
implements LineHeightSpan,
ReactSpan {
    private final int lineHeight;

    public CustomLineHeightSpan(float height) {
        this.lineHeight = (int)Math.ceil(height);
    }

    public final int getLineHeight() {
        return this.lineHeight;
    }

    public void chooseHeight(@Nullable CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        if (fm.descent > this.lineHeight) {
            fm.bottom = fm.descent = (int)Math.min((double)this.lineHeight, (double)fm.descent);
            fm.top = fm.ascent = 0;
        } else if (-fm.ascent + fm.descent > this.lineHeight) {
            fm.bottom = fm.descent;
            fm.top = fm.ascent = -this.lineHeight + fm.descent;
        } else if (-fm.ascent + fm.bottom > this.lineHeight) {
            fm.top = fm.ascent;
            fm.bottom = fm.ascent + this.lineHeight;
        } else if (-fm.top + fm.bottom > this.lineHeight) {
            fm.top = fm.bottom - this.lineHeight;
        } else {
            int additional = this.lineHeight - (-fm.top + fm.bottom);
            int top = (int)((float)fm.top - (float)Math.ceil((float)additional / 2.0f));
            int bottom = (int)((float)fm.bottom + (float)Math.floor((float)additional / 2.0f));
            fm.top = top;
            fm.ascent = top;
            fm.descent = bottom;
            fm.bottom = bottom;
        }
    }
}

