/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import android.view.Choreographer;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.modules.core.JavaScriptTimerExecutor;
import com.facebook.react.modules.core.JavaTimerManager;
import com.facebook.react.modules.core.ReactChoreographer;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0016\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0005>?@ABB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J(\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fH\u0016J \u0010+\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u000fH\u0017J\u0010\u0010.\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0017J\u0015\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020-H\u0000\u00a2\u0006\u0002\b1J\b\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\"H\u0002J\u0010\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020&H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u00105\u001a\u00020&H\u0016J\b\u00107\u001a\u00020\"H\u0016J\b\u00108\u001a\u00020\"H\u0016J\b\u00109\u001a\u00020\"H\u0016J\b\u0010:\u001a\u00020\"H\u0016J\b\u0010;\u001a\u00020\"H\u0002J\b\u0010<\u001a\u00020\"H\u0002J\u0010\u0010=\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u000fH\u0017R\u0014\u0010\f\u001a\b\u0018\u00010\rR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "Lcom/facebook/react/jstasks/HeadlessJsTaskEventListener;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "javaScriptTimerExecutor", "Lcom/facebook/react/modules/core/JavaScriptTimerExecutor;", "reactChoreographer", "Lcom/facebook/react/modules/core/ReactChoreographer;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/modules/core/JavaScriptTimerExecutor;Lcom/facebook/react/modules/core/ReactChoreographer;Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "currentIdleCallbackRunnable", "Lcom/facebook/react/modules/core/JavaTimerManager$IdleCallbackRunnable;", "frameCallbackPosted", "", "frameIdleCallbackPosted", "idleCallbackGuard", "", "idleFrameCallback", "Lcom/facebook/react/modules/core/JavaTimerManager$IdleFrameCallback;", "isPaused", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRunningTasks", "sendIdleEvents", "timerFrameCallback", "Lcom/facebook/react/modules/core/JavaTimerManager$TimerFrameCallback;", "timerGuard", "timerIdsToTimers", "Landroid/util/SparseArray;", "Lcom/facebook/react/modules/core/JavaTimerManager$Timer;", "timers", "Ljava/util/PriorityQueue;", "clearChoreographerIdleCallback", "", "clearFrameCallback", "createAndMaybeCallTimer", "timerId", "", "duration", "jsSchedulingTime", "", "repeat", "createTimer", "delay", "", "deleteTimer", "hasActiveTimersInRange", "rangeMs", "hasActiveTimersInRange$ReactAndroid_debug", "maybeIdleCallback", "maybeSetChoreographerIdleCallback", "onHeadlessJsTaskFinish", "taskId", "onHeadlessJsTaskStart", "onHostDestroy", "onHostPause", "onHostResume", "onInstanceDestroy", "setChoreographerCallback", "setChoreographerIdleCallback", "setSendIdleEvents", "Companion", "IdleCallbackRunnable", "IdleFrameCallback", "Timer", "TimerFrameCallback", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nJavaTimerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTimerManager.kt\ncom/facebook/react/modules/core/JavaTimerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1#2:365\n*E\n"})
public class JavaTimerManager
implements LifecycleEventListener,
HeadlessJsTaskEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactApplicationContext;
    @NotNull
    private final JavaScriptTimerExecutor javaScriptTimerExecutor;
    @NotNull
    private final ReactChoreographer reactChoreographer;
    @NotNull
    private final DevSupportManager devSupportManager;
    @NotNull
    private final Object timerGuard;
    @NotNull
    private final Object idleCallbackGuard;
    @NotNull
    private final SparseArray<Timer> timerIdsToTimers;
    @NotNull
    private final AtomicBoolean isPaused;
    @NotNull
    private final AtomicBoolean isRunningTasks;
    @NotNull
    private final TimerFrameCallback timerFrameCallback;
    @NotNull
    private final IdleFrameCallback idleFrameCallback;
    @Nullable
    private IdleCallbackRunnable currentIdleCallbackRunnable;
    private boolean frameCallbackPosted;
    private boolean frameIdleCallbackPosted;
    private boolean sendIdleEvents;
    @NotNull
    private final PriorityQueue<Timer> timers;
    private static final float IDLE_CALLBACK_FRAME_DEADLINE_MS = 1.0f;
    private static final float FRAME_DURATION_MS = 16.666666f;
    private static final int TIMER_QUEUE_CAPACITY = 11;

    public JavaTimerManager(@NotNull ReactApplicationContext reactApplicationContext, @NotNull JavaScriptTimerExecutor javaScriptTimerExecutor, @NotNull ReactChoreographer reactChoreographer, @NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter((Object)javaScriptTimerExecutor, (String)"javaScriptTimerExecutor");
        Intrinsics.checkNotNullParameter((Object)reactChoreographer, (String)"reactChoreographer");
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        this.reactApplicationContext = reactApplicationContext;
        this.javaScriptTimerExecutor = javaScriptTimerExecutor;
        this.reactChoreographer = reactChoreographer;
        this.devSupportManager = devSupportManager;
        this.timerGuard = new Object();
        this.idleCallbackGuard = new Object();
        this.timerIdsToTimers = new SparseArray();
        this.isPaused = new AtomicBoolean(true);
        this.isRunningTasks = new AtomicBoolean(false);
        this.timerFrameCallback = new TimerFrameCallback();
        this.idleFrameCallback = new IdleFrameCallback();
        this.timers = new PriorityQueue(11, (arg_0, arg_1) -> JavaTimerManager.timers$lambda$0(timers.1.INSTANCE, arg_0, arg_1));
        this.reactApplicationContext.addLifecycleEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isPaused.set(true);
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostResume() {
        this.isPaused.set(false);
        this.setChoreographerCallback();
        this.maybeSetChoreographerIdleCallback();
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
        if (!this.isRunningTasks.getAndSet(true)) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        }
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.reactApplicationContext);
        if (!headlessJsTaskContext.hasActiveTasks()) {
            this.isRunningTasks.set(false);
            this.clearFrameCallback();
            this.maybeIdleCallback();
        }
    }

    public void onInstanceDestroy() {
        this.reactApplicationContext.removeLifecycleEventListener(this);
        this.clearFrameCallback();
        this.clearChoreographerIdleCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maybeSetChoreographerIdleCallback() {
        Object object = this.idleCallbackGuard;
        synchronized (object) {
            boolean bl = false;
            if (this.sendIdleEvents) {
                this.setChoreographerIdleCallback();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void maybeIdleCallback() {
        if (this.isPaused.get() && !this.isRunningTasks.get()) {
            this.clearFrameCallback();
        }
    }

    private final void setChoreographerCallback() {
        if (!this.frameCallbackPosted) {
            this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.timerFrameCallback);
            this.frameCallbackPosted = true;
        }
    }

    private final void clearFrameCallback() {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.reactApplicationContext);
        if (this.frameCallbackPosted && this.isPaused.get() && !headlessJsTaskContext.hasActiveTasks()) {
            this.reactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.timerFrameCallback);
            this.frameCallbackPosted = false;
        }
    }

    private final void setChoreographerIdleCallback() {
        if (!this.frameIdleCallbackPosted) {
            this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.idleFrameCallback);
            this.frameIdleCallbackPosted = true;
        }
    }

    private final void clearChoreographerIdleCallback() {
        if (this.frameIdleCallbackPosted) {
            this.reactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.idleFrameCallback);
            this.frameIdleCallbackPosted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void createTimer(int timerId, long delay, boolean repeat) {
        long initialTargetTime = SystemClock.nanoTime() / (long)1000000 + delay;
        Timer timer = new Timer(timerId, initialTargetTime, (int)delay, repeat);
        Object object = this.timerGuard;
        synchronized (object) {
            boolean bl = false;
            this.timers.add(timer);
            this.timerIdsToTimers.put(timerId, (Object)timer);
            Unit unit = Unit.INSTANCE;
        }
    }

    public void createAndMaybeCallTimer(int timerId, int duration, double jsSchedulingTime, boolean repeat) {
        long driftTime;
        long deviceTime = SystemClock.currentTimeMillis();
        long remoteTime = (long)jsSchedulingTime;
        if (this.devSupportManager.getDevSupportEnabled() && (driftTime = Math.abs(remoteTime - deviceTime)) > 60000L) {
            this.javaScriptTimerExecutor.emitTimeDriftWarning("Debugger and device times have drifted by more than 60s. Please correct this by running adb shell \"date `date +%m%d%H%M%Y.%S`\" on your debugger machine.");
        }
        long adjustedDuration = Math.max(0L, remoteTime - deviceTime + (long)duration);
        if (duration == 0 && !repeat) {
            WritableArray timerToCall = Arguments.createArray();
            timerToCall.pushInt(timerId);
            Intrinsics.checkNotNull((Object)timerToCall);
            this.javaScriptTimerExecutor.callTimers(timerToCall);
            return;
        }
        this.createTimer(timerId, adjustedDuration, repeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void deleteTimer(int timerId) {
        Object object = this.timerGuard;
        synchronized (object) {
            Timer timer;
            boolean bl = false;
            Timer timer2 = timer = (Timer)this.timerIdsToTimers.get(timerId);
            if (timer2 == null) {
                return;
            }
            Intrinsics.checkNotNull((Object)timer2);
            Timer timer3 = timer;
            this.timerIdsToTimers.remove(timerId);
            boolean bl2 = this.timers.remove(timer3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void setSendIdleEvents(boolean sendIdleEvents) {
        Object object = this.idleCallbackGuard;
        synchronized (object) {
            boolean bl = false;
            this.sendIdleEvents = sendIdleEvents;
            Unit unit = Unit.INSTANCE;
        }
        UiThreadUtil.runOnUiThread(() -> JavaTimerManager.setSendIdleEvents$lambda$6(this, sendIdleEvents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasActiveTimersInRange$ReactAndroid_debug(long rangeMs) {
        Object object = this.timerGuard;
        synchronized (object) {
            block8: {
                Timer timer;
                block7: {
                    boolean bl = false;
                    timer = this.timers.peek();
                    if (timer != null) break block7;
                    boolean bl2 = false;
                    return bl2;
                }
                Timer nextTimer = timer;
                if (!JavaTimerManager.Companion.isTimerInRange(nextTimer, rangeMs)) break block8;
                boolean bl = true;
                return bl;
            }
            for (Timer timer : this.timers) {
                Intrinsics.checkNotNull((Object)timer);
                if (!JavaTimerManager.Companion.isTimerInRange(timer, rangeMs)) continue;
                boolean bl = true;
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        return false;
    }

    private static final int timers$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setSendIdleEvents$lambda$6(JavaTimerManager this$0, boolean $sendIdleEvents) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.idleCallbackGuard;
        synchronized (object) {
            boolean bl = false;
            if ($sendIdleEvents) {
                this$0.setChoreographerIdleCallback();
            } else {
                this$0.clearChoreographerIdleCallback();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$Companion;", "", "()V", "FRAME_DURATION_MS", "", "IDLE_CALLBACK_FRAME_DEADLINE_MS", "TIMER_QUEUE_CAPACITY", "", "isTimerInRange", "", "timer", "Lcom/facebook/react/modules/core/JavaTimerManager$Timer;", "rangeMs", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isTimerInRange(Timer timer, long rangeMs) {
            return !timer.getRepeat() && (long)timer.getInterval() < rangeMs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$IdleCallbackRunnable;", "Ljava/lang/Runnable;", "frameStartTime", "", "(Lcom/facebook/react/modules/core/JavaTimerManager;J)V", "isCancelled", "", "cancel", "", "run", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nJavaTimerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTimerManager.kt\ncom/facebook/react/modules/core/JavaTimerManager$IdleCallbackRunnable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1#2:365\n*E\n"})
    private final class IdleCallbackRunnable
    implements Runnable {
        private final long frameStartTime;
        private volatile boolean isCancelled;

        public IdleCallbackRunnable(long frameStartTime) {
            this.frameStartTime = frameStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isCancelled) {
                return;
            }
            long frameTimeMillis = this.frameStartTime / (long)1000000;
            long timeSinceBoot = SystemClock.uptimeMillis();
            long frameTimeElapsed = timeSinceBoot - frameTimeMillis;
            long time = SystemClock.currentTimeMillis();
            long absoluteFrameStartTime = time - frameTimeElapsed;
            if (16.666666f - (float)frameTimeElapsed < 1.0f) {
                return;
            }
            boolean sendIdleEvents = false;
            Object object = JavaTimerManager.this.idleCallbackGuard;
            JavaTimerManager javaTimerManager = JavaTimerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                sendIdleEvents = javaTimerManager.sendIdleEvents;
                Unit unit = Unit.INSTANCE;
            }
            if (sendIdleEvents) {
                JavaTimerManager.this.javaScriptTimerExecutor.callIdleCallbacks(absoluteFrameStartTime);
            }
            JavaTimerManager.this.currentIdleCallbackRunnable = null;
        }

        public final void cancel() {
            this.isCancelled = true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$IdleFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "(Lcom/facebook/react/modules/core/JavaTimerManager;)V", "doFrame", "", "frameTimeNanos", "", "ReactAndroid_debug"})
    private final class IdleFrameCallback
    implements Choreographer.FrameCallback {
        public void doFrame(long frameTimeNanos) {
            if (JavaTimerManager.this.isPaused.get() && !JavaTimerManager.this.isRunningTasks.get()) {
                return;
            }
            IdleCallbackRunnable idleCallbackRunnable = JavaTimerManager.this.currentIdleCallbackRunnable;
            if (idleCallbackRunnable != null) {
                idleCallbackRunnable.cancel();
            }
            JavaTimerManager.this.currentIdleCallbackRunnable = new IdleCallbackRunnable(frameTimeNanos);
            JavaTimerManager.this.reactApplicationContext.runOnJSQueueThread(JavaTimerManager.this.currentIdleCallbackRunnable);
            JavaTimerManager.this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$Timer;", "", "timerId", "", "targetTime", "", "interval", "repeat", "", "(IJIZ)V", "getInterval", "()I", "getRepeat", "()Z", "getTargetTime", "()J", "setTargetTime", "(J)V", "getTimerId", "ReactAndroid_debug"})
    private static final class Timer {
        private final int timerId;
        private long targetTime;
        private final int interval;
        private final boolean repeat;

        public Timer(int timerId, long targetTime, int interval, boolean repeat) {
            this.timerId = timerId;
            this.targetTime = targetTime;
            this.interval = interval;
            this.repeat = repeat;
        }

        public final int getTimerId() {
            return this.timerId;
        }

        public final long getTargetTime() {
            return this.targetTime;
        }

        public final void setTargetTime(long l) {
            this.targetTime = l;
        }

        public final int getInterval() {
            return this.interval;
        }

        public final boolean getRepeat() {
            return this.repeat;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/modules/core/JavaTimerManager$TimerFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "(Lcom/facebook/react/modules/core/JavaTimerManager;)V", "timersToCall", "Lcom/facebook/react/bridge/WritableArray;", "doFrame", "", "frameTimeNanos", "", "ReactAndroid_debug"})
    private final class TimerFrameCallback
    implements Choreographer.FrameCallback {
        @Nullable
        private WritableArray timersToCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            if (JavaTimerManager.this.isPaused.get() && !JavaTimerManager.this.isRunningTasks.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / (long)1000000;
            Object object = JavaTimerManager.this.timerGuard;
            Object object2 = JavaTimerManager.this;
            Object object3 = object;
            synchronized (object3) {
                boolean $i$a$-synchronized-JavaTimerManager$TimerFrameCallback$doFrame$22 = false;
                while (!((JavaTimerManager)object2).timers.isEmpty()) {
                    Timer timer;
                    Object e = ((JavaTimerManager)object2).timers.peek();
                    Intrinsics.checkNotNull(e);
                    if (((Timer)e).getTargetTime() >= frameTimeMillis || (timer = (Timer)((JavaTimerManager)object2).timers.poll()) == null) break;
                    if (this.timersToCall == null) {
                        this.timersToCall = Arguments.createArray();
                    }
                    WritableArray writableArray = this.timersToCall;
                    if (writableArray != null) {
                        writableArray.pushInt(timer.getTimerId());
                    }
                    if (timer.getRepeat()) {
                        timer.setTargetTime(frameTimeMillis + (long)timer.getInterval());
                        ((JavaTimerManager)object2).timers.add(timer);
                        continue;
                    }
                    ((JavaTimerManager)object2).timerIdsToTimers.remove(timer.getTimerId());
                }
                Unit $i$a$-synchronized-JavaTimerManager$TimerFrameCallback$doFrame$22 = Unit.INSTANCE;
            }
            WritableArray writableArray = this.timersToCall;
            if (writableArray != null) {
                object2 = writableArray;
                object3 = JavaTimerManager.this;
                Object it = object2;
                boolean bl = false;
                ((JavaTimerManager)object3).javaScriptTimerExecutor.callTimers((WritableArray)it);
                this.timersToCall = null;
            }
            JavaTimerManager.this.reactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
        }
    }
}

