/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONArguments {
    public static ReadableMap fromJSONObject(JSONObject obj) throws JSONException {
        WritableMap result = Arguments.createMap();
        Iterator keys2 = obj.keys();
        while (keys2.hasNext()) {
            String key = (String)keys2.next();
            Object val = obj.get(key);
            if (val instanceof JSONObject) {
                result.putMap(key, JSONArguments.fromJSONObject((JSONObject)val));
                continue;
            }
            if (val instanceof JSONArray) {
                result.putArray(key, JSONArguments.fromJSONArray((JSONArray)val));
                continue;
            }
            if (val instanceof String) {
                result.putString(key, (String)val);
                continue;
            }
            if (val instanceof Boolean) {
                result.putBoolean(key, (Boolean)val);
                continue;
            }
            if (val instanceof Integer) {
                result.putInt(key, (Integer)val);
                continue;
            }
            if (val instanceof Double) {
                result.putDouble(key, (Double)val);
                continue;
            }
            if (val instanceof Long) {
                result.putInt(key, ((Long)val).intValue());
                continue;
            }
            if (obj.isNull(key)) {
                result.putNull(key);
                continue;
            }
            throw new JSONException("Unexpected value when parsing JSON object. key: " + key);
        }
        return result;
    }

    public static ReadableMap fromJSONObjectString(String objStr) throws JSONException {
        return JSONArguments.fromJSONObject(new JSONObject(objStr));
    }

    public static ReadableArray fromJSONArray(JSONArray arr) throws JSONException {
        WritableArray result = Arguments.createArray();
        for (int i = 0; i < arr.length(); ++i) {
            Object val = arr.get(i);
            if (val instanceof JSONObject) {
                result.pushMap(JSONArguments.fromJSONObject((JSONObject)val));
                continue;
            }
            if (val instanceof JSONArray) {
                result.pushArray(JSONArguments.fromJSONArray((JSONArray)val));
                continue;
            }
            if (val instanceof String) {
                result.pushString((String)val);
                continue;
            }
            if (val instanceof Boolean) {
                result.pushBoolean((Boolean)val);
                continue;
            }
            if (val instanceof Integer) {
                result.pushInt((Integer)val);
                continue;
            }
            if (val instanceof Double) {
                result.pushDouble((Double)val);
                continue;
            }
            if (val instanceof Long) {
                result.pushInt(((Long)val).intValue());
                continue;
            }
            if (arr.isNull(i)) {
                result.pushNull();
                continue;
            }
            throw new JSONException("Unexpected value when parsing JSON array. index: " + i);
        }
        return result;
    }

    public static ReadableArray fromJSONArrayString(String arrStr) throws JSONException {
        return JSONArguments.fromJSONArray(new JSONArray(arrStr));
    }
}

