/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.debuggingoverlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.views.debuggingoverlay.TraceUpdate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DebuggingOverlay
extends View {
    private final Paint mTraceUpdatePaint = new Paint();
    private HashMap<Integer, TraceUpdate> mTraceUpdatesToDisplayMap = new HashMap();
    private HashMap<Integer, Runnable> mTraceUpdateIdToCleanupRunnableMap = new HashMap();
    private final Paint mHighlightedElementsPaint = new Paint();
    private List<RectF> mHighlightedElementsRectangles = new ArrayList<RectF>();

    public DebuggingOverlay(Context context) {
        super(context);
        this.mTraceUpdatePaint.setStyle(Paint.Style.STROKE);
        this.mTraceUpdatePaint.setStrokeWidth(6.0f);
        this.mHighlightedElementsPaint.setStyle(Paint.Style.FILL);
        this.mHighlightedElementsPaint.setColor(-859248897);
    }

    @UiThread
    public void setTraceUpdates(List<TraceUpdate> traceUpdates) {
        for (TraceUpdate traceUpdate : traceUpdates) {
            int traceUpdateId = traceUpdate.getId();
            if (this.mTraceUpdateIdToCleanupRunnableMap.containsKey(traceUpdateId)) {
                UiThreadUtil.removeOnUiThread(this.mTraceUpdateIdToCleanupRunnableMap.get(traceUpdateId));
                this.mTraceUpdateIdToCleanupRunnableMap.remove(traceUpdateId);
            }
            this.mTraceUpdatesToDisplayMap.put(traceUpdateId, traceUpdate);
        }
        this.invalidate();
    }

    @UiThread
    public void setHighlightedElementsRectangles(List<RectF> elementsRectangles) {
        this.mHighlightedElementsRectangles = elementsRectangles;
        this.invalidate();
    }

    @UiThread
    public void clearElementsHighlights() {
        this.mHighlightedElementsRectangles.clear();
        this.invalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (TraceUpdate traceUpdate : this.mTraceUpdatesToDisplayMap.values()) {
            this.mTraceUpdatePaint.setColor(traceUpdate.getColor());
            canvas.drawRect(traceUpdate.getRectangle(), this.mTraceUpdatePaint);
            int traceUpdateId = traceUpdate.getId();
            Runnable block = () -> {
                this.mTraceUpdatesToDisplayMap.remove(traceUpdateId);
                this.mTraceUpdateIdToCleanupRunnableMap.remove(traceUpdateId);
                this.invalidate();
            };
            if (this.mTraceUpdateIdToCleanupRunnableMap.containsKey(traceUpdateId)) continue;
            this.mTraceUpdateIdToCleanupRunnableMap.put(traceUpdateId, block);
            UiThreadUtil.runOnUiThread(block, 2000L);
        }
        for (RectF elementRectangle : this.mHighlightedElementsRectangles) {
            canvas.drawRect(elementRectangle, this.mHighlightedElementsPaint);
        }
    }
}

