/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.text.CustomLetterSpacingSpan;
import com.facebook.react.views.text.CustomLineHeightSpan;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.FontMetricsUtil;
import com.facebook.react.views.text.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.ReactBackgroundColorSpan;
import com.facebook.react.views.text.ReactClickableSpan;
import com.facebook.react.views.text.ReactForegroundColorSpan;
import com.facebook.react.views.text.ReactStrikethroughSpan;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.ReactUnderlineSpan;
import com.facebook.react.views.text.SetSpanOperation;
import com.facebook.react.views.text.ShadowStyleSpan;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextInlineViewPlaceholderSpan;
import com.facebook.react.views.text.TextTransform;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class TextLayoutManagerMapBuffer {
    public static final short AS_KEY_HASH = 0;
    public static final short AS_KEY_STRING = 1;
    public static final short AS_KEY_FRAGMENTS = 2;
    public static final short AS_KEY_CACHE_ID = 3;
    public static final short FR_KEY_STRING = 0;
    public static final short FR_KEY_REACT_TAG = 1;
    public static final short FR_KEY_IS_ATTACHMENT = 2;
    public static final short FR_KEY_WIDTH = 3;
    public static final short FR_KEY_HEIGHT = 4;
    public static final short FR_KEY_TEXT_ATTRIBUTES = 5;
    public static final short PA_KEY_MAX_NUMBER_OF_LINES = 0;
    public static final short PA_KEY_ELLIPSIZE_MODE = 1;
    public static final short PA_KEY_TEXT_BREAK_STRATEGY = 2;
    public static final short PA_KEY_ADJUST_FONT_SIZE_TO_FIT = 3;
    public static final short PA_KEY_INCLUDE_FONT_PADDING = 4;
    public static final short PA_KEY_HYPHENATION_FREQUENCY = 5;
    private static final boolean ENABLE_MEASURE_LOGGING = false;
    private static final String TAG = TextLayoutManagerMapBuffer.class.getSimpleName();
    private static final TextPaint sTextPaintInstance = new TextPaint(1);
    private static final short spannableCacheSize = 10000;
    private static final String INLINE_VIEW_PLACEHOLDER = "0";
    private static final boolean DEFAULT_INCLUDE_FONT_PADDING = true;
    private static final Object sCacheLock = new Object();
    private static final ConcurrentHashMap<Integer, Spannable> sTagToSpannableCache = new ConcurrentHashMap();
    private static final LruCache<ReadableMapBuffer, Spannable> sSpannableCache = new LruCache(10000);

    public static void setCachedSpannabledForTag(int reactTag, @NonNull Spannable sp) {
        sTagToSpannableCache.put(reactTag, sp);
    }

    public static void deleteCachedSpannableForTag(int reactTag) {
        sTagToSpannableCache.remove(reactTag);
    }

    public static boolean isRTL(MapBuffer attributedString) {
        MapBuffer fragments = attributedString.getMapBuffer(2);
        if (fragments.getCount() == 0) {
            return false;
        }
        MapBuffer fragment = fragments.getMapBuffer(0);
        MapBuffer textAttributes = fragment.getMapBuffer(5);
        if (!textAttributes.contains(23)) {
            return false;
        }
        return TextAttributeProps.getLayoutDirection(textAttributes.getString(23)) == 1;
    }

    private static void buildSpannableFromFragment(Context context, MapBuffer fragments, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int length = fragments.getCount();
        for (int i = 0; i < length; ++i) {
            boolean roleIsLink;
            int reactTag;
            MapBuffer fragment = fragments.getMapBuffer(i);
            int start = sb.length();
            TextAttributeProps textAttributes = TextAttributeProps.fromMapBuffer(fragment.getMapBuffer(5));
            sb.append((CharSequence)TextTransform.apply(fragment.getString(0), textAttributes.mTextTransform));
            int end = sb.length();
            int n = reactTag = fragment.contains(1) ? fragment.getInt(1) : -1;
            if (fragment.contains(2) && fragment.getBoolean(2)) {
                float width = PixelUtil.toPixelFromSP(fragment.getDouble(3));
                float height = PixelUtil.toPixelFromSP(fragment.getDouble(4));
                ops.add(new SetSpanOperation(sb.length() - INLINE_VIEW_PLACEHOLDER.length(), sb.length(), new TextInlineViewPlaceholderSpan(reactTag, (int)width, (int)height)));
                continue;
            }
            if (end < start) continue;
            boolean bl = textAttributes.mRole != null ? textAttributes.mRole == ReactAccessibilityDelegate.Role.LINK : (roleIsLink = textAttributes.mAccessibilityRole == ReactAccessibilityDelegate.AccessibilityRole.LINK);
            if (roleIsLink) {
                ops.add(new SetSpanOperation(start, end, new ReactClickableSpan(reactTag)));
            }
            if (textAttributes.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactForegroundColorSpan(textAttributes.mColor)));
            }
            if (textAttributes.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactBackgroundColorSpan(textAttributes.mBackgroundColor)));
            }
            if (!Float.isNaN(textAttributes.getLetterSpacing())) {
                ops.add(new SetSpanOperation(start, end, new CustomLetterSpacingSpan(textAttributes.getLetterSpacing())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactAbsoluteSizeSpan(textAttributes.mFontSize)));
            if (textAttributes.mFontStyle != -1 || textAttributes.mFontWeight != -1 || textAttributes.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, new CustomStyleSpan(textAttributes.mFontStyle, textAttributes.mFontWeight, textAttributes.mFontFeatureSettings, textAttributes.mFontFamily, context.getAssets())));
            }
            if (textAttributes.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactUnderlineSpan()));
            }
            if (textAttributes.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactStrikethroughSpan()));
            }
            if ((textAttributes.mTextShadowOffsetDx != 0.0f || textAttributes.mTextShadowOffsetDy != 0.0f || textAttributes.mTextShadowRadius != 0.0f) && Color.alpha((int)textAttributes.mTextShadowColor) != 0) {
                ops.add(new SetSpanOperation(start, end, new ShadowStyleSpan(textAttributes.mTextShadowOffsetDx, textAttributes.mTextShadowOffsetDy, textAttributes.mTextShadowRadius, textAttributes.mTextShadowColor)));
            }
            if (!Float.isNaN(textAttributes.getEffectiveLineHeight())) {
                ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(textAttributes.getEffectiveLineHeight())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(reactTag)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Spannable getOrCreateSpannableForText(Context context, MapBuffer attributedString, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        Spannable text = null;
        if (attributedString.contains(3)) {
            Integer cacheId = attributedString.getInt(3);
            text = sTagToSpannableCache.get(cacheId);
        } else if (ReactFeatureFlags.enableTextSpannableCache && attributedString instanceof ReadableMapBuffer) {
            ReadableMapBuffer mapBuffer = (ReadableMapBuffer)attributedString;
            Object object = sCacheLock;
            synchronized (object) {
                text = (Spannable)sSpannableCache.get((Object)mapBuffer);
                if (text == null) {
                    text = TextLayoutManagerMapBuffer.createSpannableFromAttributedString(context, attributedString, reactTextViewManagerCallback);
                    sSpannableCache.put((Object)mapBuffer, (Object)text);
                }
            }
        } else {
            text = TextLayoutManagerMapBuffer.createSpannableFromAttributedString(context, attributedString, reactTextViewManagerCallback);
        }
        return text;
    }

    private static Spannable createSpannableFromAttributedString(Context context, MapBuffer attributedString, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        TextLayoutManagerMapBuffer.buildSpannableFromFragment(context, attributedString.getMapBuffer(2), sb, ops);
        for (int priorityIndex = 0; priorityIndex < ops.size(); ++priorityIndex) {
            SetSpanOperation op = (SetSpanOperation)ops.get(ops.size() - priorityIndex - 1);
            op.execute(sb, priorityIndex);
        }
        if (reactTextViewManagerCallback != null) {
            reactTextViewManagerCallback.onPostProcessSpannable((Spannable)sb);
        }
        return sb;
    }

    private static Layout createLayout(Spannable text, BoringLayout.Metrics boring, float width, YogaMeasureMode widthYogaMeasureMode, boolean includeFontPadding, int textBreakStrategy, int hyphenationFrequency) {
        StaticLayout layout2;
        float desiredWidth;
        int spanLength = text.length();
        boolean unconstrainedWidth = widthYogaMeasureMode == YogaMeasureMode.UNDEFINED || width < 0.0f;
        float f = desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)sTextPaintInstance) : Float.NaN;
        if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width)) {
            int hintWidth = (int)Math.ceil(desiredWidth);
            layout2 = Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, sTextPaintInstance, hintWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, includeFontPadding) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)spanLength, (TextPaint)sTextPaintInstance, (int)hintWidth).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(hyphenationFrequency).build();
        } else if (boring != null && (unconstrainedWidth || (float)boring.width <= width)) {
            int boringLayoutWidth = boring.width;
            if (boring.width < 0) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Text width is invalid: " + boring.width));
                boringLayoutWidth = 0;
            }
            layout2 = BoringLayout.make((CharSequence)text, (TextPaint)sTextPaintInstance, (int)boringLayoutWidth, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)includeFontPadding);
        } else if (Build.VERSION.SDK_INT < 23) {
            layout2 = new StaticLayout((CharSequence)text, sTextPaintInstance, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, includeFontPadding);
        } else {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)spanLength, (TextPaint)sTextPaintInstance, (int)((int)width)).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(hyphenationFrequency);
            if (Build.VERSION.SDK_INT >= 28) {
                builder.setUseLineSpacingFromFallbacks(true);
            }
            layout2 = builder.build();
        }
        return layout2;
    }

    public static long measureText(Context context, MapBuffer attributedString, MapBuffer paragraphAttributes, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode, ReactTextViewManagerCallback reactTextViewManagerCallback, @Nullable float[] attachmentsPositions) {
        Spannable text = TextLayoutManagerMapBuffer.getOrCreateSpannableForText(context, attributedString, reactTextViewManagerCallback);
        if (text == null) {
            return 0L;
        }
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        boolean includeFontPadding = paragraphAttributes.contains(4) ? paragraphAttributes.getBoolean(4) : true;
        int hyphenationFrequency = TextAttributeProps.getHyphenationFrequency(paragraphAttributes.getString(5));
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)sTextPaintInstance);
        Layout layout2 = TextLayoutManagerMapBuffer.createLayout(text, boring, width, widthYogaMeasureMode, includeFontPadding, textBreakStrategy, hyphenationFrequency);
        int maximumNumberOfLines = paragraphAttributes.contains(0) ? paragraphAttributes.getInt(0) : -1;
        int calculatedLineCount = maximumNumberOfLines == -1 || maximumNumberOfLines == 0 ? layout2.getLineCount() : Math.min(maximumNumberOfLines, layout2.getLineCount());
        float calculatedWidth = 0.0f;
        if (widthYogaMeasureMode == YogaMeasureMode.EXACTLY) {
            calculatedWidth = width;
        } else {
            for (int lineIndex = 0; lineIndex < calculatedLineCount; ++lineIndex) {
                float lineWidth;
                boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(lineIndex) - 1) == '\n';
                float f = lineWidth = endsWithNewLine ? layout2.getLineMax(lineIndex) : layout2.getLineWidth(lineIndex);
                if (!(lineWidth > calculatedWidth)) continue;
                calculatedWidth = lineWidth;
            }
            if (widthYogaMeasureMode == YogaMeasureMode.AT_MOST && calculatedWidth > width) {
                calculatedWidth = width;
            }
        }
        if (Build.VERSION.SDK_INT > 29) {
            calculatedWidth = (float)Math.ceil(calculatedWidth);
        }
        float calculatedHeight = height;
        if (heightYogaMeasureMode != YogaMeasureMode.EXACTLY) {
            calculatedHeight = layout2.getLineBottom(calculatedLineCount - 1);
            if (heightYogaMeasureMode == YogaMeasureMode.AT_MOST && calculatedHeight > height) {
                calculatedHeight = height;
            }
        }
        int attachmentIndex = 0;
        int i = 0;
        while (i < text.length()) {
            TextInlineViewPlaceholderSpan[] placeholders;
            int lastAttachmentFoundInSpan = text.nextSpanTransition(i, text.length(), TextInlineViewPlaceholderSpan.class);
            for (TextInlineViewPlaceholderSpan placeholder : placeholders = (TextInlineViewPlaceholderSpan[])text.getSpans(i, lastAttachmentFoundInSpan, TextInlineViewPlaceholderSpan.class)) {
                float placeholderLeftPosition;
                boolean isRtlParagraph;
                boolean isLineTruncated;
                int start = text.getSpanStart((Object)placeholder);
                int line = layout2.getLineForOffset(start);
                boolean bl = isLineTruncated = layout2.getEllipsisCount(line) > 0;
                if (isLineTruncated && start >= layout2.getLineStart(line) + layout2.getEllipsisStart(line) && start < layout2.getLineEnd(line)) continue;
                float placeholderWidth = placeholder.getWidth();
                float placeholderHeight = placeholder.getHeight();
                boolean isRtlChar = layout2.isRtlCharAt(start);
                boolean bl2 = isRtlParagraph = layout2.getParagraphDirection(line) == -1;
                if (start == text.length() - 1) {
                    boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(line) - 1) == '\n';
                    float lineWidth = endsWithNewLine ? layout2.getLineMax(line) : layout2.getLineWidth(line);
                    placeholderLeftPosition = isRtlParagraph ? calculatedWidth - lineWidth : layout2.getLineRight(line) - placeholderWidth;
                } else {
                    boolean characterAndParagraphDirectionMatch = isRtlParagraph == isRtlChar;
                    float f = placeholderLeftPosition = characterAndParagraphDirectionMatch ? layout2.getPrimaryHorizontal(start) : layout2.getSecondaryHorizontal(start);
                    if (isRtlParagraph) {
                        placeholderLeftPosition = calculatedWidth - (layout2.getLineRight(line) - placeholderLeftPosition);
                    }
                    if (isRtlChar) {
                        placeholderLeftPosition -= placeholderWidth;
                    }
                }
                float placeholderTopPosition = (float)layout2.getLineBaseline(line) - placeholderHeight;
                int attachmentPosition = attachmentIndex * 2;
                attachmentsPositions[attachmentPosition] = PixelUtil.toDIPFromPixel(placeholderTopPosition);
                attachmentsPositions[attachmentPosition + 1] = PixelUtil.toDIPFromPixel(placeholderLeftPosition);
                ++attachmentIndex;
            }
            i = lastAttachmentFoundInSpan;
        }
        float widthInSP = PixelUtil.toDIPFromPixel(calculatedWidth);
        float heightInSP = PixelUtil.toDIPFromPixel(calculatedHeight);
        return YogaMeasureOutput.make(widthInSP, heightInSP);
    }

    public static WritableArray measureLines(@NonNull Context context, MapBuffer attributedString, MapBuffer paragraphAttributes, float width) {
        Spannable text = TextLayoutManagerMapBuffer.getOrCreateSpannableForText(context, attributedString, null);
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)sTextPaintInstance);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        boolean includeFontPadding = paragraphAttributes.contains(4) ? paragraphAttributes.getBoolean(4) : true;
        int hyphenationFrequency = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(5));
        Layout layout2 = TextLayoutManagerMapBuffer.createLayout(text, boring, width, YogaMeasureMode.EXACTLY, includeFontPadding, textBreakStrategy, hyphenationFrequency);
        return FontMetricsUtil.getFontMetrics((CharSequence)text, layout2, sTextPaintInstance, context);
    }
}

