/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.util;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.util.RCTLog;

public class RNLog {
    public static final int MINIMUM_LEVEL_FOR_UI = 5;
    public static final int LOG = 2;
    public static final int TRACE = 3;
    public static final int ADVICE = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    public static void l(String message) {
        FLog.i((String)"ReactNative", (String)message);
    }

    public static void t(String message) {
        FLog.i((String)"ReactNative", (String)message);
    }

    public static void a(String message) {
        FLog.w((String)"ReactNative", (String)("(ADVICE)" + message));
    }

    public static void w(ReactContext context, String message) {
        RNLog.logInternal(context, message, 5);
        FLog.w((String)"ReactNative", (String)message);
    }

    public static void e(ReactContext context, String message) {
        RNLog.logInternal(context, message, 6);
        FLog.e((String)"ReactNative", (String)message);
    }

    public static void e(String message) {
        FLog.e((String)"ReactNative", (String)message);
    }

    private static void logInternal(ReactContext context, String message, int level) {
        if (level >= 5 && context != null && context.hasActiveReactInstance() && message != null) {
            context.getJSModule(RCTLog.class).logIfNoNativeHook(RNLog.levelToString(level), message);
        }
    }

    private static String levelToString(int level) {
        switch (level) {
            case 2: 
            case 3: {
                return "log";
            }
            case 4: 
            case 5: {
                return "warn";
            }
            case 6: {
                return "error";
            }
        }
        return "none";
    }
}

