/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.view.View;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.yoga.YogaMeasureMode;

public interface LayoutMetricsConversions {
    public static float getMinSize(int viewMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)viewMeasureSpec);
        int size = View.MeasureSpec.getSize((int)viewMeasureSpec);
        return mode == 0x40000000 ? (float)size : 0.0f;
    }

    public static float getMaxSize(int viewMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)viewMeasureSpec);
        int size = View.MeasureSpec.getSize((int)viewMeasureSpec);
        return mode == 0 ? Float.POSITIVE_INFINITY : (float)size;
    }

    public static float getYogaSize(float minSize, float maxSize) {
        if (minSize == maxSize) {
            return PixelUtil.toPixelFromDIP(maxSize);
        }
        if (Float.isInfinite(maxSize)) {
            return Float.POSITIVE_INFINITY;
        }
        return PixelUtil.toPixelFromDIP(maxSize);
    }

    public static YogaMeasureMode getYogaMeasureMode(float minSize, float maxSize) {
        if (minSize == maxSize) {
            return YogaMeasureMode.EXACTLY;
        }
        if (Float.isInfinite(maxSize)) {
            return YogaMeasureMode.UNDEFINED;
        }
        return YogaMeasureMode.AT_MOST;
    }
}

