/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.Nullable;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UnstableReactNativeAPI
public abstract class LazyTurboModuleManagerDelegate
extends ReactPackageTurboModuleManagerDelegate {
    private final List<ReactPackage> mPackages;
    private final ReactApplicationContext mReactContext;
    private final Map<String, TurboModule> mModules = new HashMap<String, TurboModule>();

    public LazyTurboModuleManagerDelegate(ReactApplicationContext reactApplicationContext, List<ReactPackage> packages) {
        this.mPackages = packages;
        this.mReactContext = reactApplicationContext;
    }

    @Override
    @Nullable
    public TurboModule getModule(String moduleName) {
        TurboModule nativeModule = this.mModules.get(moduleName);
        if (nativeModule == null) {
            for (ReactPackage reactPackage : this.mPackages) {
                if (reactPackage instanceof TurboReactPackage) {
                    TurboReactPackage turboPkg = (TurboReactPackage)reactPackage;
                    try {
                        nativeModule = (TurboModule)((Object)turboPkg.getModule(moduleName, this.mReactContext));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (nativeModule == null) continue;
                    this.mModules.put(moduleName, nativeModule);
                    nativeModule.initialize();
                    return nativeModule;
                }
                throw new IllegalArgumentException("ReactPackage must be an instance of TurboReactPackage");
            }
        }
        return nativeModule;
    }

    @Override
    public boolean unstable_isModuleRegistered(String moduleName) {
        return this.getModule(moduleName) != null;
    }

    @Override
    public boolean unstable_shouldEnableLegacyModuleInterop() {
        return false;
    }

    @Override
    public boolean unstable_shouldRouteTurboModulesThroughLegacyModuleInterop() {
        return false;
    }

    @Override
    public NativeModule getLegacyModule(String moduleName) {
        throw new UnsupportedOperationException("Legacy Modules are not supported");
    }

    @Override
    public boolean unstable_isLegacyModuleRegistered(String moduleName) {
        return false;
    }
}

