/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;

final class SendAccessibilityEventMountItem
implements MountItem {
    private final String TAG = "Fabric.SendAccessibilityEvent";
    private final int mSurfaceId;
    private final int mReactTag;
    private final int mEventType;

    SendAccessibilityEventMountItem(int surfaceId, int reactTag, int eventType) {
        this.mSurfaceId = surfaceId;
        this.mReactTag = reactTag;
        this.mEventType = eventType;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        try {
            mountingManager.sendAccessibilityEvent(this.mSurfaceId, this.mReactTag, this.mEventType);
        }
        catch (RetryableMountingLayerException e) {
            ReactSoftExceptionLogger.logSoftException("Fabric.SendAccessibilityEvent", e);
        }
    }

    @Override
    public int getSurfaceId() {
        return this.mSurfaceId;
    }

    @NonNull
    public String toString() {
        return "SendAccessibilityEventMountItem [" + this.mReactTag + "] " + this.mEventType;
    }
}

