/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.events;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.fabric.FabricSoLoader;

@SuppressLint(value={"MissingNativeLoadLibrary"})
public class EventEmitterWrapper {
    @DoNotStrip
    private final HybridData mHybridData = EventEmitterWrapper.initHybrid();

    private static native HybridData initHybrid();

    private EventEmitterWrapper() {
    }

    private native void invokeEvent(@NonNull String var1, @NonNull NativeMap var2, int var3);

    private native void invokeUniqueEvent(@NonNull String var1, @NonNull NativeMap var2, int var3);

    public synchronized void invoke(@NonNull String eventName, @Nullable WritableMap params, int eventCategory) {
        if (!this.isValid()) {
            return;
        }
        this.invokeEvent(eventName, (NativeMap)((Object)params), eventCategory);
    }

    public synchronized void invokeUnique(@NonNull String eventName, @Nullable WritableMap params, int customCoalesceKey) {
        if (!this.isValid()) {
            return;
        }
        this.invokeUniqueEvent(eventName, (NativeMap)((Object)params), customCoalesceKey);
    }

    public synchronized void destroy() {
        if (this.mHybridData != null) {
            this.mHybridData.resetNative();
        }
    }

    private boolean isValid() {
        if (this.mHybridData != null) {
            return this.mHybridData.isValid();
        }
        return false;
    }

    static {
        FabricSoLoader.staticInit();
    }
}

