/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.devsupport.LogBoxDialog;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.util.RNLog;

public class LogBoxDialogSurfaceDelegate
implements SurfaceDelegate {
    @Nullable
    private View mReactRootView;
    @Nullable
    private LogBoxDialog mDialog;
    private final DevSupportManager mDevSupportManager;

    LogBoxDialogSurfaceDelegate(DevSupportManager devSupportManager) {
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public void createContentView(String appKey) {
        Assertions.assertCondition((boolean)appKey.equals("LogBox"), (String)"This surface manager can only create LogBox React application");
        this.mReactRootView = this.mDevSupportManager.createRootView("LogBox");
        if (this.mReactRootView == null) {
            RNLog.e("Unable to launch logbox because react was unable to create the root view");
        }
    }

    @Override
    public boolean isContentViewReady() {
        return this.mReactRootView != null;
    }

    @Override
    public void destroyContentView() {
        if (this.mReactRootView != null) {
            this.mDevSupportManager.destroyRootView(this.mReactRootView);
            this.mReactRootView = null;
        }
    }

    @Override
    public void show() {
        if (this.isShowing() || !this.isContentViewReady()) {
            return;
        }
        Activity context = this.mDevSupportManager.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            RNLog.e("Unable to launch logbox because react activity is not available, here is the error that logbox would've displayed: ");
            return;
        }
        this.mDialog = new LogBoxDialog(context, this.mReactRootView);
        this.mDialog.setCancelable(false);
        this.mDialog.show();
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        if (this.mReactRootView != null && this.mReactRootView.getParent() != null) {
            ((ViewGroup)this.mReactRootView.getParent()).removeView(this.mReactRootView);
        }
        this.mDialog.dismiss();
        this.mDialog = null;
    }

    @Override
    public boolean isShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }
}

