/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.OverScroller;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.FabricViewStateManager;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class ReactScrollViewHelper {
    private static String TAG = ReactHorizontalScrollView.class.getSimpleName();
    private static boolean DEBUG_MODE = false;
    private static final String CONTENT_OFFSET_LEFT = "contentOffsetLeft";
    private static final String CONTENT_OFFSET_TOP = "contentOffsetTop";
    private static final String SCROLL_AWAY_PADDING_TOP = "scrollAwayPaddingTop";
    public static final long MOMENTUM_DELAY = 20L;
    public static final String OVER_SCROLL_ALWAYS = "always";
    public static final String AUTO = "auto";
    public static final String OVER_SCROLL_NEVER = "never";
    public static final int SNAP_ALIGNMENT_DISABLED = 0;
    public static final int SNAP_ALIGNMENT_START = 1;
    public static final int SNAP_ALIGNMENT_CENTER = 2;
    public static final int SNAP_ALIGNMENT_END = 3;
    private static final Set<ScrollListener> sScrollListeners = Collections.newSetFromMap(new WeakHashMap());
    private static int SMOOTH_SCROLL_DURATION = 250;
    private static boolean mSmoothScrollDurationInitialized = false;

    public static <T extends ViewGroup> void emitScrollEvent(T scrollView, float xVelocity, float yVelocity) {
        ReactScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.SCROLL, xVelocity, yVelocity);
    }

    public static <T extends ViewGroup> void emitScrollBeginDragEvent(T scrollView) {
        ReactScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.BEGIN_DRAG);
    }

    public static <T extends ViewGroup> void emitScrollEndDragEvent(T scrollView, float xVelocity, float yVelocity) {
        ReactScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.END_DRAG, xVelocity, yVelocity);
    }

    public static <T extends ViewGroup> void emitScrollMomentumBeginEvent(T scrollView, int xVelocity, int yVelocity) {
        ReactScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_BEGIN, xVelocity, yVelocity);
    }

    public static <T extends ViewGroup> void emitScrollMomentumEndEvent(T scrollView) {
        ReactScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_END);
    }

    private static <T extends ViewGroup> void emitScrollEvent(T scrollView, ScrollEventType scrollEventType) {
        ReactScrollViewHelper.emitScrollEvent(scrollView, scrollEventType, 0.0f, 0.0f);
    }

    private static <T extends ViewGroup> void emitScrollEvent(T scrollView, ScrollEventType scrollEventType, float xVelocity, float yVelocity) {
        long now = System.currentTimeMillis();
        View contentView = scrollView.getChildAt(0);
        if (contentView == null) {
            return;
        }
        for (ScrollListener scrollListener : sScrollListeners) {
            scrollListener.onScroll(scrollView, scrollEventType, xVelocity, yVelocity);
        }
        ReactContext reactContext = (ReactContext)scrollView.getContext();
        int surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, scrollView.getId());
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent(ScrollEvent.obtain(surfaceId, scrollView.getId(), scrollEventType, scrollView.getScrollX(), scrollView.getScrollY(), xVelocity, yVelocity, contentView.getWidth(), contentView.getHeight(), scrollView.getWidth(), scrollView.getHeight()));
            ((HasScrollEventThrottle)scrollView).setLastScrollDispatchTime(now);
        }
    }

    public static void emitLayoutEvent(ViewGroup scrollView) {
        for (ScrollListener scrollListener : sScrollListeners) {
            scrollListener.onLayout(scrollView);
        }
    }

    public static int parseOverScrollMode(String jsOverScrollMode) {
        if (jsOverScrollMode == null || jsOverScrollMode.equals(AUTO)) {
            return 1;
        }
        if (jsOverScrollMode.equals(OVER_SCROLL_ALWAYS)) {
            return 0;
        }
        if (jsOverScrollMode.equals(OVER_SCROLL_NEVER)) {
            return 2;
        }
        FLog.w((String)"ReactNative", (String)("wrong overScrollMode: " + jsOverScrollMode));
        return 1;
    }

    public static int parseSnapToAlignment(@Nullable String alignment) {
        if (alignment == null) {
            return 0;
        }
        if ("start".equalsIgnoreCase(alignment)) {
            return 1;
        }
        if ("center".equalsIgnoreCase(alignment)) {
            return 2;
        }
        if ("end".equals(alignment)) {
            return 3;
        }
        FLog.w((String)"ReactNative", (String)("wrong snap alignment value: " + alignment));
        return 0;
    }

    public static int getDefaultScrollAnimationDuration(Context context) {
        if (!mSmoothScrollDurationInitialized) {
            mSmoothScrollDurationInitialized = true;
            try {
                OverScrollerDurationGetter overScrollerDurationGetter = new OverScrollerDurationGetter(context);
                SMOOTH_SCROLL_DURATION = overScrollerDurationGetter.getScrollAnimationDuration();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SMOOTH_SCROLL_DURATION;
    }

    public static void addScrollListener(ScrollListener listener) {
        sScrollListeners.add(listener);
    }

    public static void removeScrollListener(ScrollListener listener) {
        sScrollListeners.remove(listener);
    }

    public static <T extends ViewGroup & HasScrollState> void smoothScrollTo(T scrollView, int x, int y) {
        ValueAnimator flingAnimator;
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"smoothScrollTo[%d] x %d y %d", (Object)scrollView.getId(), (Object)x, (Object)y);
        }
        if ((flingAnimator = ((HasFlingAnimator)scrollView).getFlingAnimator()).getListeners() == null || flingAnimator.getListeners().size() == 0) {
            ReactScrollViewHelper.registerFlingAnimator(scrollView);
        }
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        scrollState.setFinalAnimatedPositionScroll(x, y);
        int scrollX = scrollView.getScrollX();
        int scrollY = scrollView.getScrollY();
        if (scrollX != x) {
            ((HasFlingAnimator)scrollView).startFlingAnimator(scrollX, x);
        }
        if (scrollY != y) {
            ((HasFlingAnimator)scrollView).startFlingAnimator(scrollY, y);
        }
        ReactScrollViewHelper.updateFabricScrollState(scrollView, x, y);
    }

    public static <T extends ViewGroup & HasScrollState> int getNextFlingStartValue(T scrollView, int currentValue, int postAnimationValue, int velocity) {
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        int velocityDirectionMask = velocity != 0 ? velocity / Math.abs(velocity) : 0;
        boolean isMovingTowardsAnimatedValue = velocityDirectionMask * (postAnimationValue - currentValue) > 0;
        return !scrollState.getIsFinished() || scrollState.getIsCanceled() && isMovingTowardsAnimatedValue ? postAnimationValue : currentValue;
    }

    public static <T extends ViewGroup & HasScrollState> boolean updateFabricScrollState(T scrollView) {
        return ReactScrollViewHelper.updateFabricScrollState(scrollView, scrollView.getScrollX(), scrollView.getScrollY());
    }

    public static <T extends ViewGroup & HasScrollState> boolean updateFabricScrollState(T scrollView, int scrollX, int scrollY) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"updateFabricScrollState[%d] scrollX %d scrollY %d", (Object)scrollView.getId(), (Object)scrollX, (Object)scrollY);
        }
        if (ViewUtil.getUIManagerType(scrollView.getId()) == 1) {
            return false;
        }
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        if (scrollState.getLastStateUpdateScroll().equals(scrollX, scrollY)) {
            return false;
        }
        scrollState.setLastStateUpdateScroll(scrollX, scrollY);
        ReactScrollViewHelper.forceUpdateState(scrollView);
        return true;
    }

    public static <T extends ViewGroup & HasScrollState> void forceUpdateState(T scrollView) {
        int fabricScrollX;
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        final int scrollAwayPaddingTop = scrollState.getScrollAwayPaddingTop();
        Point scrollPos = scrollState.getLastStateUpdateScroll();
        final int scrollX = scrollPos.x;
        final int scrollY = scrollPos.y;
        int layoutDirection = scrollState.getLayoutDirection();
        if (layoutDirection == 1) {
            View child = scrollView.getChildAt(0);
            int contentWidth = child != null ? child.getWidth() : 0;
            fabricScrollX = -(contentWidth - scrollX - scrollView.getWidth());
        } else {
            fabricScrollX = scrollX;
        }
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"updateFabricScrollState[%d] scrollX %d scrollY %d fabricScrollX", (Object)scrollView.getId(), (Object)scrollX, (Object)scrollY, (Object)fabricScrollX);
        }
        ((FabricViewStateManager.HasFabricViewStateManager)scrollView).getFabricViewStateManager().setState(new FabricViewStateManager.StateUpdateCallback(){

            @Override
            public WritableMap getStateUpdate() {
                WritableNativeMap map = new WritableNativeMap();
                map.putDouble(ReactScrollViewHelper.CONTENT_OFFSET_LEFT, PixelUtil.toDIPFromPixel(scrollX));
                map.putDouble(ReactScrollViewHelper.CONTENT_OFFSET_TOP, PixelUtil.toDIPFromPixel(scrollY));
                map.putDouble(ReactScrollViewHelper.SCROLL_AWAY_PADDING_TOP, PixelUtil.toDIPFromPixel(scrollAwayPaddingTop));
                return map;
            }
        });
    }

    public static <T extends ViewGroup & HasScrollState & HasScrollEventThrottle> void updateStateOnScrollChanged(T scrollView, float xVelocity, float yVelocity) {
        ReactScrollViewHelper.updateFabricScrollState(scrollView);
        ReactScrollViewHelper.emitScrollEvent(scrollView, xVelocity, yVelocity);
    }

    public static <T extends ViewGroup & HasScrollState> void registerFlingAnimator(final T scrollView) {
        ((HasFlingAnimator)scrollView).getFlingAnimator().addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
                scrollState.setIsCanceled(false);
                scrollState.setIsFinished(false);
            }

            public void onAnimationEnd(Animator animator) {
                ((HasScrollState)scrollView).getReactScrollViewScrollState().setIsFinished(true);
                ReactScrollViewHelper.updateFabricScrollState(scrollView);
            }

            public void onAnimationCancel(Animator animator) {
                ((HasScrollState)scrollView).getReactScrollViewScrollState().setIsCanceled(true);
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
    }

    public static <T extends ViewGroup & HasScrollState> Point predictFinalScrollPosition(T scrollView, int velocityX, int velocityY, int maximumOffsetX, int maximumOffsetY) {
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        OverScroller scroller = new OverScroller(scrollView.getContext());
        scroller.setFriction(1.0f - scrollState.getDecelerationRate());
        int width = scrollView.getWidth() - ViewCompat.getPaddingStart(scrollView) - ViewCompat.getPaddingEnd(scrollView);
        int height = scrollView.getHeight() - scrollView.getPaddingBottom() - scrollView.getPaddingTop();
        Point finalAnimatedPositionScroll = scrollState.getFinalAnimatedPositionScroll();
        scroller.fling(ReactScrollViewHelper.getNextFlingStartValue(scrollView, scrollView.getScrollX(), finalAnimatedPositionScroll.x, velocityX), ReactScrollViewHelper.getNextFlingStartValue(scrollView, scrollView.getScrollY(), finalAnimatedPositionScroll.y, velocityY), velocityX, velocityY, 0, maximumOffsetX, 0, maximumOffsetY, width / 2, height / 2);
        return new Point(scroller.getFinalX(), scroller.getFinalY());
    }

    public static interface HasSmoothScroll {
        public void reactSmoothScrollTo(int var1, int var2);
    }

    public static interface HasScrollEventThrottle {
        public void setScrollEventThrottle(int var1);

        public int getScrollEventThrottle();

        public void setLastScrollDispatchTime(long var1);

        public long getLastScrollDispatchTime();
    }

    public static interface HasFlingAnimator {
        public void startFlingAnimator(int var1, int var2);

        public ValueAnimator getFlingAnimator();

        public int getFlingExtrapolatedDistance(int var1);
    }

    public static interface HasScrollState {
        public ReactScrollViewScrollState getReactScrollViewScrollState();
    }

    public static class ReactScrollViewScrollState {
        private final int mLayoutDirection;
        private final Point mFinalAnimatedPositionScroll = new Point();
        private int mScrollAwayPaddingTop = 0;
        private final Point mLastStateUpdateScroll = new Point(-1, -1);
        private boolean mIsCanceled = false;
        private boolean mIsFinished = true;
        private float mDecelerationRate = 0.985f;

        public ReactScrollViewScrollState(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
        }

        public int getLayoutDirection() {
            return this.mLayoutDirection;
        }

        public Point getFinalAnimatedPositionScroll() {
            return this.mFinalAnimatedPositionScroll;
        }

        public ReactScrollViewScrollState setFinalAnimatedPositionScroll(int finalAnimatedPositionScrollX, int finalAnimatedPositionScrollY) {
            this.mFinalAnimatedPositionScroll.set(finalAnimatedPositionScrollX, finalAnimatedPositionScrollY);
            return this;
        }

        public Point getLastStateUpdateScroll() {
            return this.mLastStateUpdateScroll;
        }

        public ReactScrollViewScrollState setLastStateUpdateScroll(int lastStateUpdateScrollX, int lastStateUpdateScrollY) {
            this.mLastStateUpdateScroll.set(lastStateUpdateScrollX, lastStateUpdateScrollY);
            return this;
        }

        public int getScrollAwayPaddingTop() {
            return this.mScrollAwayPaddingTop;
        }

        public ReactScrollViewScrollState setScrollAwayPaddingTop(int scrollAwayPaddingTop) {
            this.mScrollAwayPaddingTop = scrollAwayPaddingTop;
            return this;
        }

        public boolean getIsCanceled() {
            return this.mIsCanceled;
        }

        public ReactScrollViewScrollState setIsCanceled(boolean isCanceled) {
            this.mIsCanceled = isCanceled;
            return this;
        }

        public boolean getIsFinished() {
            return this.mIsFinished;
        }

        public ReactScrollViewScrollState setIsFinished(boolean isFinished) {
            this.mIsFinished = isFinished;
            return this;
        }

        public float getDecelerationRate() {
            return this.mDecelerationRate;
        }

        public ReactScrollViewScrollState setDecelerationRate(float decelerationRate) {
            this.mDecelerationRate = decelerationRate;
            return this;
        }
    }

    private static class OverScrollerDurationGetter
    extends OverScroller {
        private int mScrollAnimationDuration = 250;

        OverScrollerDurationGetter(Context context) {
            super(context);
        }

        public int getScrollAnimationDuration() {
            super.startScroll(0, 0, 0, 0);
            return this.mScrollAnimationDuration;
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            this.mScrollAnimationDuration = duration;
        }
    }

    public static interface ScrollListener {
        public void onScroll(ViewGroup var1, ScrollEventType var2, float var3, float var4);

        public void onLayout(ViewGroup var1);
    }
}

