/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.devloading;

import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativeDevLoadingViewSpec;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.BridgeDevSupportManager;
import com.facebook.react.devsupport.DefaultDevLoadingViewImplementation;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="DevLoadingView")
public class DevLoadingModule
extends NativeDevLoadingViewSpec {
    private final JSExceptionHandler mJSExceptionHandler;
    @Nullable
    private DevLoadingViewManager mDevLoadingViewManager;

    public DevLoadingModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mJSExceptionHandler = reactContext.getJSExceptionHandler();
        if (this.mJSExceptionHandler != null && this.mJSExceptionHandler instanceof BridgeDevSupportManager) {
            this.mDevLoadingViewManager = ((BridgeDevSupportManager)this.mJSExceptionHandler).getDevLoadingViewManager();
            this.mDevLoadingViewManager = this.mDevLoadingViewManager != null ? this.mDevLoadingViewManager : new DefaultDevLoadingViewImplementation(((BridgeDevSupportManager)this.mJSExceptionHandler).getReactInstanceManagerHelper());
        }
    }

    @Override
    public void showMessage(final String message, Double color, Double backgroundColor) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevLoadingModule.this.mDevLoadingViewManager.showMessage(message);
            }
        });
    }

    @Override
    public void hide() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevLoadingModule.this.mDevLoadingViewManager != null) {
                    DevLoadingModule.this.mDevLoadingViewManager.hide();
                }
            }
        });
    }
}

