/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchesHelper;

public class ReactEventEmitter
implements RCTModernEventEmitter {
    private static final String TAG = "ReactEventEmitter";
    @Nullable
    private RCTModernEventEmitter mFabricEventEmitter = null;
    @Nullable
    private RCTEventEmitter mRCTEventEmitter = null;
    private final ReactApplicationContext mReactContext;

    public ReactEventEmitter(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
    }

    public void register(int uiManagerType, RCTModernEventEmitter eventEmitter) {
        assert (uiManagerType == 2);
        this.mFabricEventEmitter = eventEmitter;
    }

    public void register(int uiManagerType, RCTEventEmitter eventEmitter) {
        assert (uiManagerType == 1);
        this.mRCTEventEmitter = eventEmitter;
    }

    public void unregister(int uiManagerType) {
        if (uiManagerType == 1) {
            this.mRCTEventEmitter = null;
        } else {
            this.mFabricEventEmitter = null;
        }
    }

    @Override
    public void receiveEvent(int targetReactTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(-1, targetReactTag, eventName, event);
    }

    @Override
    public void receiveEvent(int surfaceId, int targetTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(surfaceId, targetTag, eventName, false, 0, event, 2);
    }

    @Override
    public void receiveTouches(String eventName, WritableArray touches, WritableArray changedIndices) {
        Assertions.assertCondition((touches.size() > 0 ? 1 : 0) != 0);
        int reactTag = touches.getMap(0).getInt("target");
        int uiManagerType = ViewUtil.getUIManagerType(reactTag);
        if (uiManagerType == 1 && this.getEventEmitter(reactTag) != null) {
            this.mRCTEventEmitter.receiveTouches(eventName, touches, changedIndices);
        }
    }

    @Override
    public void receiveTouches(TouchEvent event) {
        int reactTag = event.getViewTag();
        int uiManagerType = event.getUIManagerType();
        if (uiManagerType == 2 && this.mFabricEventEmitter != null) {
            this.mFabricEventEmitter.receiveTouches(event);
        } else if (uiManagerType == 1 && this.getEventEmitter(reactTag) != null) {
            TouchesHelper.sendTouchesLegacy(this.mRCTEventEmitter, event);
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot find EventEmitter for receivedTouches: ReactTag[" + reactTag + "] UIManagerType[" + uiManagerType + "] EventName[" + event.getEventName() + "]"));
        }
    }

    @Nullable
    private RCTEventEmitter getEventEmitter(int reactTag) {
        int type = ViewUtil.getUIManagerType(reactTag);
        assert (type == 1);
        if (this.mRCTEventEmitter == null) {
            if (this.mReactContext.hasActiveReactInstance()) {
                this.mRCTEventEmitter = this.mReactContext.getJSModule(RCTEventEmitter.class);
            } else {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get RCTEventEmitter from Context for reactTag: " + reactTag + " - uiManagerType: " + type + " - No active Catalyst instance!"));
            }
        }
        return this.mRCTEventEmitter;
    }

    @Override
    public void receiveEvent(int surfaceId, int targetReactTag, String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap event, int category) {
        int uiManagerType = ViewUtil.getUIManagerType(targetReactTag);
        if (uiManagerType == 2 && this.mFabricEventEmitter != null) {
            this.mFabricEventEmitter.receiveEvent(surfaceId, targetReactTag, eventName, canCoalesceEvent, customCoalesceKey, event, category);
        } else if (uiManagerType == 1 && this.getEventEmitter(targetReactTag) != null) {
            this.mRCTEventEmitter.receiveEvent(targetReactTag, eventName, event);
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot find EventEmitter for receiveEvent: SurfaceId[" + surfaceId + "] ReactTag[" + targetReactTag + "] UIManagerType[" + uiManagerType + "] EventName[" + eventName + "]"));
        }
    }
}

