/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import androidx.annotation.NonNull;
import com.facebook.react.bridge.JSIModuleProvider;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.fabric.Binding;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.ReactNativeConfig;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.systrace.Systrace;

public class FabricJSIModuleProvider
implements JSIModuleProvider<UIManager> {
    @NonNull
    private final ReactApplicationContext mReactApplicationContext;
    @NonNull
    private final ComponentFactory mComponentFactory;
    @NonNull
    private final ReactNativeConfig mConfig;
    @NonNull
    private final ViewManagerRegistry mViewManagerRegistry;

    public FabricJSIModuleProvider(@NonNull ReactApplicationContext reactApplicationContext, @NonNull ComponentFactory componentFactory, @NonNull ReactNativeConfig config, @NonNull ViewManagerRegistry viewManagerRegistry) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mComponentFactory = componentFactory;
        this.mConfig = config;
        this.mViewManagerRegistry = viewManagerRegistry;
    }

    @Override
    public UIManager get() {
        Systrace.beginSection(0L, "FabricJSIModuleProvider.get");
        EventBeatManager eventBeatManager = new EventBeatManager(this.mReactApplicationContext);
        FabricUIManager uiManager = this.createUIManager(eventBeatManager);
        Systrace.beginSection(0L, "FabricJSIModuleProvider.registerBinding");
        Binding binding = new Binding();
        binding.register(this.mReactApplicationContext.getCatalystInstance().getRuntimeExecutor(), this.mReactApplicationContext.getCatalystInstance().getRuntimeScheduler(), uiManager, eventBeatManager, this.mComponentFactory, this.mConfig);
        Systrace.endSection(0L);
        Systrace.endSection(0L);
        return uiManager;
    }

    private FabricUIManager createUIManager(@NonNull EventBeatManager eventBeatManager) {
        Systrace.beginSection(0L, "FabricJSIModuleProvider.createUIManager");
        FabricUIManager fabricUIManager = new FabricUIManager(this.mReactApplicationContext, this.mViewManagerRegistry, eventBeatManager);
        Systrace.endSection(0L);
        return fabricUIManager;
    }
}

