/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.app.Activity;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeDialogManagerAndroidSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.dialog.AlertFragment;
import java.util.Map;

@ReactModule(name="DialogManagerAndroid")
public class DialogModule
extends NativeDialogManagerAndroidSpec
implements LifecycleEventListener {
    static final String FRAGMENT_TAG = "com.facebook.catalyst.react.dialog.DialogModule";
    public static final String NAME = "DialogManagerAndroid";
    static final String ACTION_BUTTON_CLICKED = "buttonClicked";
    static final String ACTION_DISMISSED = "dismissed";
    static final String KEY_TITLE = "title";
    static final String KEY_MESSAGE = "message";
    static final String KEY_BUTTON_POSITIVE = "buttonPositive";
    static final String KEY_BUTTON_NEGATIVE = "buttonNegative";
    static final String KEY_BUTTON_NEUTRAL = "buttonNeutral";
    static final String KEY_ITEMS = "items";
    static final String KEY_CANCELABLE = "cancelable";
    static final Map<String, Object> CONSTANTS = MapBuilder.of("buttonClicked", "buttonClicked", "dismissed", "dismissed", "buttonPositive", -1, "buttonNegative", -2, "buttonNeutral", -3);
    private boolean mIsInForeground;

    public DialogModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @NonNull
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getTypedExportedConstants() {
        return CONSTANTS;
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.mIsInForeground = false;
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onHostResume() {
        this.mIsInForeground = true;
        FragmentManagerHelper fragmentManagerHelper = this.getFragmentManagerHelper();
        if (fragmentManagerHelper != null) {
            fragmentManagerHelper.showPendingAlert();
        } else {
            FLog.w(DialogModule.class, (String)"onHostResume called but no FragmentManager found");
        }
    }

    @Override
    public void showAlert(ReadableMap options, Callback errorCallback, final Callback actionCallback) {
        final FragmentManagerHelper fragmentManagerHelper = this.getFragmentManagerHelper();
        if (fragmentManagerHelper == null) {
            errorCallback.invoke("Tried to show an alert while not attached to an Activity");
            return;
        }
        final Bundle args = new Bundle();
        if (options.hasKey(KEY_TITLE)) {
            args.putString(KEY_TITLE, options.getString(KEY_TITLE));
        }
        if (options.hasKey(KEY_MESSAGE)) {
            args.putString(KEY_MESSAGE, options.getString(KEY_MESSAGE));
        }
        if (options.hasKey(KEY_BUTTON_POSITIVE)) {
            args.putString("button_positive", options.getString(KEY_BUTTON_POSITIVE));
        }
        if (options.hasKey(KEY_BUTTON_NEGATIVE)) {
            args.putString("button_negative", options.getString(KEY_BUTTON_NEGATIVE));
        }
        if (options.hasKey(KEY_BUTTON_NEUTRAL)) {
            args.putString("button_neutral", options.getString(KEY_BUTTON_NEUTRAL));
        }
        if (options.hasKey(KEY_ITEMS)) {
            ReadableArray items = options.getArray(KEY_ITEMS);
            CharSequence[] itemsArray = new CharSequence[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                itemsArray[i] = items.getString(i);
            }
            args.putCharSequenceArray(KEY_ITEMS, itemsArray);
        }
        if (options.hasKey(KEY_CANCELABLE)) {
            args.putBoolean(KEY_CANCELABLE, options.getBoolean(KEY_CANCELABLE));
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                fragmentManagerHelper.showNewAlert(args, actionCallback);
            }
        });
    }

    @Nullable
    private FragmentManagerHelper getFragmentManagerHelper() {
        Activity activity = this.getCurrentActivity();
        if (activity == null || !(activity instanceof FragmentActivity)) {
            return null;
        }
        return new FragmentManagerHelper(((FragmentActivity)activity).getSupportFragmentManager());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        ReactApplicationContext applicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (applicationContext != null) {
            applicationContext.removeLifecycleEventListener(this);
        }
    }

    class AlertFragmentListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnDismissListener {
        private final Callback mCallback;
        private boolean mCallbackConsumed = false;

        public AlertFragmentListener(Callback callback) {
            this.mCallback = callback;
        }

        public void onClick(DialogInterface dialog, int which) {
            if (!this.mCallbackConsumed && DialogModule.this.getReactApplicationContext().hasActiveReactInstance()) {
                this.mCallback.invoke(DialogModule.ACTION_BUTTON_CLICKED, which);
                this.mCallbackConsumed = true;
            }
        }

        public void onDismiss(DialogInterface dialog) {
            if (!this.mCallbackConsumed && DialogModule.this.getReactApplicationContext().hasActiveReactInstance()) {
                this.mCallback.invoke(DialogModule.ACTION_DISMISSED);
                this.mCallbackConsumed = true;
            }
        }
    }

    private class FragmentManagerHelper {
        @NonNull
        private final FragmentManager mFragmentManager;
        @Nullable
        private Object mFragmentToShow;

        public FragmentManagerHelper(FragmentManager fragmentManager) {
            this.mFragmentManager = fragmentManager;
        }

        public void showPendingAlert() {
            UiThreadUtil.assertOnUiThread();
            SoftAssertions.assertCondition(DialogModule.this.mIsInForeground, "showPendingAlert() called in background");
            if (this.mFragmentToShow == null) {
                return;
            }
            this.dismissExisting();
            ((AlertFragment)((Object)this.mFragmentToShow)).show(this.mFragmentManager, DialogModule.FRAGMENT_TAG);
            this.mFragmentToShow = null;
        }

        private void dismissExisting() {
            if (!DialogModule.this.mIsInForeground) {
                return;
            }
            AlertFragment oldFragment = (AlertFragment)this.mFragmentManager.findFragmentByTag(DialogModule.FRAGMENT_TAG);
            if (oldFragment != null && oldFragment.isResumed()) {
                oldFragment.dismiss();
            }
        }

        public void showNewAlert(Bundle arguments, Callback actionCallback) {
            UiThreadUtil.assertOnUiThread();
            this.dismissExisting();
            AlertFragmentListener actionListener = actionCallback != null ? new AlertFragmentListener(actionCallback) : null;
            AlertFragment alertFragment = new AlertFragment(actionListener, arguments);
            if (DialogModule.this.mIsInForeground && !this.mFragmentManager.isStateSaved()) {
                if (arguments.containsKey(DialogModule.KEY_CANCELABLE)) {
                    alertFragment.setCancelable(arguments.getBoolean(DialogModule.KEY_CANCELABLE));
                }
                alertFragment.show(this.mFragmentManager, DialogModule.FRAGMENT_TAG);
            } else {
                this.mFragmentToShow = alertFragment;
            }
        }
    }
}

