/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativeDeviceEventManagerSpec;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;

@ReactModule(name="DeviceEventManager")
public class DeviceEventManagerModule
extends NativeDeviceEventManagerSpec {
    public static final String NAME = "DeviceEventManager";
    private final Runnable mInvokeDefaultBackPressRunnable;

    public DeviceEventManagerModule(ReactApplicationContext reactContext, final DefaultHardwareBackBtnHandler backBtnHandler) {
        super(reactContext);
        this.mInvokeDefaultBackPressRunnable = new Runnable(){

            @Override
            public void run() {
                UiThreadUtil.assertOnUiThread();
                backBtnHandler.invokeDefaultOnBackPressed();
            }
        };
    }

    public void emitHardwareBackPressed() {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (reactApplicationContext != null) {
            reactApplicationContext.getJSModule(RCTDeviceEventEmitter.class).emit("hardwareBackPress", null);
        }
    }

    public void emitNewIntentReceived(Uri uri) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (reactApplicationContext != null) {
            WritableMap map = Arguments.createMap();
            map.putString("url", uri.toString());
            reactApplicationContext.getJSModule(RCTDeviceEventEmitter.class).emit("url", map);
        }
    }

    @Override
    public void invokeDefaultBackPressHandler() {
        this.getReactApplicationContext().runOnUiQueueThread(this.mInvokeDefaultBackPressRunnable);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @DoNotStrip
    public static interface RCTDeviceEventEmitter
    extends JavaScriptModule {
        public void emit(@NonNull String var1, @Nullable Object var2);
    }
}

