/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LanguageTagsGenerated;
import com.facebook.hermes.intl.LocaleIdTokenizer;
import com.facebook.hermes.intl.LocaleObject;
import com.facebook.hermes.intl.ParsedLocaleIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeMap;

public class LocaleIdentifier {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addVariantSubtag(String variantSubtag, ParsedLocaleIdentifier.ParsedLanguageIdentifier parsedLanguageIdentifier) throws JSRangeErrorException {
        if (parsedLanguageIdentifier.variantSubtagList != null) {
            int position = Collections.binarySearch(parsedLanguageIdentifier.variantSubtagList, variantSubtag);
            if (position >= 0) throw new JSRangeErrorException("Duplicate variant");
            parsedLanguageIdentifier.variantSubtagList.add(-1 * position - 1, variantSubtag);
            return;
        } else {
            parsedLanguageIdentifier.variantSubtagList = new ArrayList();
            parsedLanguageIdentifier.variantSubtagList.add(variantSubtag);
        }
    }

    public static void replaceLanguageSubtagIfNeeded(StringBuffer languageSubtagBuffer, StringBuffer scriptSubtagBuffer, StringBuffer regionSubtagBuffer) {
        if (LanguageTagsGenerated.languageAliasKeys2 == null) {
            return;
        }
        Object[] languageAliasKeys = null;
        String[] languageAliasReplacements = null;
        Object[] complexLanguageAliasKeys = null;
        String[] complexLanguageAliasReplacementsLanguage = null;
        String[] complexLanguageAliasReplacementsScript = null;
        String[] complexLanguageAliasReplacementsRegion = null;
        if (languageSubtagBuffer.length() == 2) {
            languageAliasKeys = LanguageTagsGenerated.languageAliasKeys2;
            languageAliasReplacements = LanguageTagsGenerated.languageAliasReplacements2;
            complexLanguageAliasKeys = LanguageTagsGenerated.complexLanguageAliasKeys2;
            complexLanguageAliasReplacementsLanguage = LanguageTagsGenerated.complexLanguageAliasReplacementsLanguage2;
            complexLanguageAliasReplacementsScript = LanguageTagsGenerated.complexLanguageAliasReplacementsScript2;
            complexLanguageAliasReplacementsRegion = LanguageTagsGenerated.complexLanguageAliasReplacementsRegion2;
        } else {
            languageAliasKeys = LanguageTagsGenerated.languageAliasKeys3;
            languageAliasReplacements = LanguageTagsGenerated.languageAliasReplacements3;
            complexLanguageAliasKeys = LanguageTagsGenerated.complexLanguageAliasKeys3;
            complexLanguageAliasReplacementsLanguage = LanguageTagsGenerated.complexLanguageAliasReplacementsLanguage3;
            complexLanguageAliasReplacementsScript = LanguageTagsGenerated.complexLanguageAliasReplacementsScript3;
            complexLanguageAliasReplacementsRegion = LanguageTagsGenerated.complexLanguageAliasReplacementsRegion3;
        }
        int found = Arrays.binarySearch(languageAliasKeys, languageSubtagBuffer.toString());
        if (found >= 0) {
            languageSubtagBuffer.delete(0, languageSubtagBuffer.length());
            languageSubtagBuffer.append(languageAliasReplacements[found]);
        } else {
            found = Arrays.binarySearch(complexLanguageAliasKeys, languageSubtagBuffer.toString());
            if (found >= 0) {
                String languageSubtagReplacement = complexLanguageAliasReplacementsLanguage[found];
                String scriptSubtagReplacement = complexLanguageAliasReplacementsScript[found];
                String regionSubtagReplacement = complexLanguageAliasReplacementsRegion[found];
                assert (languageSubtagReplacement != null && languageSubtagReplacement.length() > 0);
                languageSubtagBuffer.delete(0, languageSubtagBuffer.length());
                languageSubtagBuffer.append(languageSubtagReplacement);
                if (scriptSubtagBuffer.length() == 0 && scriptSubtagReplacement != null) {
                    scriptSubtagBuffer.append(scriptSubtagReplacement);
                }
                if (regionSubtagBuffer.length() == 0 && regionSubtagReplacement != null) {
                    regionSubtagBuffer.append(regionSubtagReplacement);
                }
            }
        }
    }

    public static String replaceRegionSubtagIfNeeded(StringBuffer regionSubtag) {
        if (LanguageTagsGenerated.regionAliasKeys2 == null) {
            return regionSubtag.toString();
        }
        if (regionSubtag.length() == 2) {
            int found = Arrays.binarySearch(LanguageTagsGenerated.regionAliasKeys2, regionSubtag.toString());
            if (found >= 0) {
                return LanguageTagsGenerated.regionAliasReplacements2[found];
            }
            return regionSubtag.toString();
        }
        int found = Arrays.binarySearch(LanguageTagsGenerated.regionAliasKeys3, regionSubtag.toString());
        if (found >= 0) {
            return LanguageTagsGenerated.regionAliasReplacements3[found];
        }
        return regionSubtag.toString();
    }

    static String canonicalizeLocaleId(String inLocaleId) throws JSRangeErrorException {
        return LocaleObject.createFromLocaleId(inLocaleId).toCanonicalTag();
    }

    static void parseUnicodeExtensions(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (!localeIdTokenizer.hasMoreSubtags()) {
            throw new JSRangeErrorException("Extension sequence expected.");
        }
        LocaleIdTokenizer.LocaleIdSubtag nextSubtag = localeIdTokenizer.nextSubtag();
        if (parsedLocaleIdentifier.unicodeExtensionAttributes != null || parsedLocaleIdentifier.unicodeExtensionKeywords != null) {
            throw new JSRangeErrorException(String.format("Duplicate unicode extension sequence in [%s]", inLocaleId));
        }
        while (nextSubtag.isUnicodeExtensionAttribute()) {
            if (parsedLocaleIdentifier.unicodeExtensionAttributes == null) {
                parsedLocaleIdentifier.unicodeExtensionAttributes = new ArrayList();
            }
            parsedLocaleIdentifier.unicodeExtensionAttributes.add(nextSubtag.toString());
            if (!localeIdTokenizer.hasMoreSubtags()) {
                return;
            }
            nextSubtag = localeIdTokenizer.nextSubtag();
        }
        if (nextSubtag.isUnicodeExtensionKey()) {
            if (parsedLocaleIdentifier.unicodeExtensionKeywords == null) {
                parsedLocaleIdentifier.unicodeExtensionKeywords = new TreeMap();
            }
            do {
                String key = nextSubtag.toString();
                ArrayList<String> extensionKeyTypes = new ArrayList<String>();
                parsedLocaleIdentifier.unicodeExtensionKeywords.put(key, extensionKeyTypes);
                if (!localeIdTokenizer.hasMoreSubtags()) {
                    return;
                }
                nextSubtag = localeIdTokenizer.nextSubtag();
                while (nextSubtag.isUnicodeExtensionKeyTypeItem()) {
                    extensionKeyTypes.add(nextSubtag.toString());
                    if (!localeIdTokenizer.hasMoreSubtags()) {
                        return;
                    }
                    nextSubtag = localeIdTokenizer.nextSubtag();
                }
            } while (nextSubtag.isUnicodeExtensionKey());
        }
        if (nextSubtag.isExtensionSingleton()) {
            LocaleIdentifier.parseExtensions(inLocaleId, nextSubtag, localeIdTokenizer, parsedLocaleIdentifier);
            return;
        }
        throw new JSRangeErrorException("Malformed sequence expected.");
    }

    static void parseTransformedExtensionFields(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, LocaleIdTokenizer.LocaleIdSubtag nextSubtag, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (nextSubtag.isTranformedExtensionTKey()) {
            if (parsedLocaleIdentifier.transformedExtensionFields != null) {
                throw new JSRangeErrorException(String.format("Duplicate transformed extension sequence in [%s]", inLocaleId));
            }
            if (parsedLocaleIdentifier.transformedExtensionFields == null) {
                parsedLocaleIdentifier.transformedExtensionFields = new TreeMap();
            }
            do {
                String tkey = nextSubtag.toString();
                ArrayList<String> tValues = new ArrayList<String>();
                parsedLocaleIdentifier.transformedExtensionFields.put(tkey, tValues);
                if (localeIdTokenizer.hasMoreSubtags()) {
                    nextSubtag = localeIdTokenizer.nextSubtag();
                    while (nextSubtag.isTranformedExtensionTValueItem()) {
                        tValues.add(nextSubtag.toString());
                        if (!localeIdTokenizer.hasMoreSubtags()) {
                            return;
                        }
                        nextSubtag = localeIdTokenizer.nextSubtag();
                    }
                } else {
                    throw new JSRangeErrorException(String.format("Malformated transformed key in : %s", inLocaleId));
                }
            } while (nextSubtag.isTranformedExtensionTKey());
        }
        if (nextSubtag.isExtensionSingleton()) {
            LocaleIdentifier.parseExtensions(inLocaleId, nextSubtag, localeIdTokenizer, parsedLocaleIdentifier);
            return;
        }
        throw new JSRangeErrorException("Malformed extension sequence.");
    }

    static void parseTransformedExtensions(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (!localeIdTokenizer.hasMoreSubtags()) {
            throw new JSRangeErrorException("Extension sequence expected.");
        }
        LocaleIdTokenizer.LocaleIdSubtag nextSubtag = localeIdTokenizer.nextSubtag();
        if (nextSubtag.isUnicodeLanguageSubtag()) {
            LocaleIdentifier.parseLanguageId(inLocaleId, localeIdTokenizer, nextSubtag, true, parsedLocaleIdentifier);
        } else if (nextSubtag.isTranformedExtensionTKey()) {
            LocaleIdentifier.parseTransformedExtensionFields(inLocaleId, localeIdTokenizer, nextSubtag, parsedLocaleIdentifier);
        } else {
            throw new JSRangeErrorException(String.format("Unexpected token [%s] in transformed extension sequence [%s]", nextSubtag.toString(), inLocaleId));
        }
    }

    static void parsePrivateUseExtensions(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (!localeIdTokenizer.hasMoreSubtags()) {
            throw new JSRangeErrorException("Extension sequence expected.");
        }
        LocaleIdTokenizer.LocaleIdSubtag nextSubtag = localeIdTokenizer.nextSubtag();
        if (parsedLocaleIdentifier.puExtensions == null) {
            parsedLocaleIdentifier.puExtensions = new ArrayList();
        }
        while (nextSubtag.isPrivateUseExtension()) {
            parsedLocaleIdentifier.puExtensions.add(nextSubtag.toString());
            if (!localeIdTokenizer.hasMoreSubtags()) {
                return;
            }
            nextSubtag = localeIdTokenizer.nextSubtag();
        }
        throw new JSRangeErrorException("Tokens are not expected after pu extension.");
    }

    static void parseOtherExtensions(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, ParsedLocaleIdentifier parsedLocaleIdentifier, char singleton) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (!localeIdTokenizer.hasMoreSubtags()) {
            throw new JSRangeErrorException("Extension sequence expected.");
        }
        LocaleIdTokenizer.LocaleIdSubtag nextSubtag = localeIdTokenizer.nextSubtag();
        if (parsedLocaleIdentifier.otherExtensionsMap == null) {
            parsedLocaleIdentifier.otherExtensionsMap = new TreeMap();
        }
        ArrayList<String> otherExtensions = new ArrayList<String>();
        parsedLocaleIdentifier.otherExtensionsMap.put(new Character(singleton), otherExtensions);
        while (nextSubtag.isOtherExtension()) {
            otherExtensions.add(nextSubtag.toString());
            if (!localeIdTokenizer.hasMoreSubtags()) {
                return;
            }
            nextSubtag = localeIdTokenizer.nextSubtag();
        }
        if (nextSubtag.isExtensionSingleton()) {
            LocaleIdentifier.parseExtensions(inLocaleId, nextSubtag, localeIdTokenizer, parsedLocaleIdentifier);
            return;
        }
        throw new JSRangeErrorException("Malformed sequence expected.");
    }

    static void parseExtensions(CharSequence inLocaleId, LocaleIdTokenizer.LocaleIdSubtag singletonSubtag, LocaleIdTokenizer localeIdTokenizer, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (!localeIdTokenizer.hasMoreSubtags()) {
            throw new JSRangeErrorException("Extension sequence expected.");
        }
        char singleton = singletonSubtag.toString().charAt(0);
        if (singleton == 'u') {
            LocaleIdentifier.parseUnicodeExtensions(inLocaleId, localeIdTokenizer, parsedLocaleIdentifier);
        } else if (singleton == 't') {
            LocaleIdentifier.parseTransformedExtensions(inLocaleId, localeIdTokenizer, parsedLocaleIdentifier);
        } else if (singleton == 'x') {
            LocaleIdentifier.parsePrivateUseExtensions(inLocaleId, localeIdTokenizer, parsedLocaleIdentifier);
        } else {
            LocaleIdentifier.parseOtherExtensions(inLocaleId, localeIdTokenizer, parsedLocaleIdentifier, singleton);
        }
    }

    static boolean handleExtensions(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, LocaleIdTokenizer.LocaleIdSubtag nextSubtag, boolean transformedExtMode, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        if (transformedExtMode && nextSubtag.isTranformedExtensionTKey()) {
            LocaleIdentifier.parseTransformedExtensionFields(inLocaleId, localeIdTokenizer, nextSubtag, parsedLocaleIdentifier);
            return true;
        }
        if (nextSubtag.isExtensionSingleton()) {
            if (!transformedExtMode) {
                LocaleIdentifier.parseExtensions(inLocaleId, nextSubtag, localeIdTokenizer, parsedLocaleIdentifier);
                return true;
            }
            throw new JSRangeErrorException(String.format("Extension singletons in transformed extension language tag: %s", inLocaleId));
        }
        return false;
    }

    static void parseLanguageId(CharSequence inLocaleId, LocaleIdTokenizer localeIdTokenizer, LocaleIdTokenizer.LocaleIdSubtag nextSubtag, boolean transformedExtMode, ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException, LocaleIdTokenizer.LocaleIdSubtagIterationFailed {
        ParsedLocaleIdentifier.ParsedLanguageIdentifier parsedLanguageIdentifier = new ParsedLocaleIdentifier.ParsedLanguageIdentifier();
        if (transformedExtMode) {
            parsedLocaleIdentifier.transformedLanguageIdentifier = parsedLanguageIdentifier;
        } else {
            parsedLocaleIdentifier.languageIdentifier = parsedLanguageIdentifier;
        }
        try {
            if (!nextSubtag.isUnicodeLanguageSubtag()) {
                throw new JSRangeErrorException(String.format("Language subtag expected at %s: %s", nextSubtag.toString(), inLocaleId));
            }
            parsedLanguageIdentifier.languageSubtag = nextSubtag.toLowerString();
            if (!localeIdTokenizer.hasMoreSubtags()) {
                return;
            }
            nextSubtag = localeIdTokenizer.nextSubtag();
            if (LocaleIdentifier.handleExtensions(inLocaleId, localeIdTokenizer, nextSubtag, transformedExtMode, parsedLocaleIdentifier)) {
                return;
            }
            if (nextSubtag.isUnicodeScriptSubtag()) {
                parsedLanguageIdentifier.scriptSubtag = nextSubtag.toTitleString();
                if (!localeIdTokenizer.hasMoreSubtags()) {
                    return;
                }
                nextSubtag = localeIdTokenizer.nextSubtag();
            }
            if (nextSubtag.isUnicodeRegionSubtag()) {
                parsedLanguageIdentifier.regionSubtag = nextSubtag.toUpperString();
                if (!localeIdTokenizer.hasMoreSubtags()) {
                    return;
                }
                nextSubtag = localeIdTokenizer.nextSubtag();
            }
            while (true) {
                if (LocaleIdentifier.handleExtensions(inLocaleId, localeIdTokenizer, nextSubtag, transformedExtMode, parsedLocaleIdentifier)) {
                    return;
                }
                if (!nextSubtag.isUnicodeVariantSubtag()) {
                    throw new JSRangeErrorException(String.format("Unknown token [%s] found in locale id: %s", nextSubtag.toString(), inLocaleId));
                }
                LocaleIdentifier.addVariantSubtag(nextSubtag.toString(), parsedLanguageIdentifier);
                if (!localeIdTokenizer.hasMoreSubtags()) {
                    return;
                }
                nextSubtag = localeIdTokenizer.nextSubtag();
            }
        }
        catch (LocaleIdTokenizer.LocaleIdSubtagIterationFailed localeIdSubtagIterationFailed) {
            throw new JSRangeErrorException(String.format("Locale Identifier subtag iteration failed: %s", inLocaleId));
        }
    }

    static ParsedLocaleIdentifier parseLocaleId(String inLocaleId, LocaleIdTokenizer localeIdTokenizer) throws JSRangeErrorException {
        ParsedLocaleIdentifier parsedLocaleIdentifier = new ParsedLocaleIdentifier();
        try {
            if (!localeIdTokenizer.hasMoreSubtags()) {
                throw new JSRangeErrorException(String.format("Language subtag not found: %s", inLocaleId));
            }
            LocaleIdTokenizer.LocaleIdSubtag nextSubtag = localeIdTokenizer.nextSubtag();
            LocaleIdentifier.parseLanguageId(inLocaleId, localeIdTokenizer, nextSubtag, false, parsedLocaleIdentifier);
            return parsedLocaleIdentifier;
        }
        catch (LocaleIdTokenizer.LocaleIdSubtagIterationFailed localeIdSubtagIterationFailed) {
            throw new JSRangeErrorException(String.format("Locale Identifier subtag iteration failed: %s", inLocaleId));
        }
    }

    static ParsedLocaleIdentifier parseLocaleId(String inLocaleId) throws JSRangeErrorException {
        int grandfatheredIndex;
        if (LanguageTagsGenerated.regularGrandfatheredKeys != null && (grandfatheredIndex = Arrays.binarySearch(LanguageTagsGenerated.regularGrandfatheredKeys, inLocaleId.toString())) >= 0) {
            inLocaleId = LanguageTagsGenerated.regularGrandfatheredReplacements[grandfatheredIndex];
        }
        inLocaleId = inLocaleId.toLowerCase();
        LocaleIdTokenizer localeIdTokenizer = new LocaleIdTokenizer(inLocaleId);
        return LocaleIdentifier.parseLocaleId(inLocaleId, localeIdTokenizer);
    }
}

