/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.text.CompactDecimalFormat;
import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.MeasureFormat;
import android.icu.text.NumberFormat;
import android.icu.text.NumberingSystem;
import android.icu.util.Currency;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.icu.util.ULocale;
import androidx.annotation.RequiresApi;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformNumberFormatter;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleObjectICU;
import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.util.ArrayList;

public class PlatformNumberFormatterICU
implements IPlatformNumberFormatter {
    private Format mFinalFormat;
    private NumberFormat mNumberFormat;
    private LocaleObjectICU mLocaleObject;
    private IPlatformNumberFormatter.Style mStyle;
    private MeasureUnit mMeasureUnit;

    PlatformNumberFormatterICU() {
    }

    @RequiresApi(api=24)
    private void initialize(NumberFormat numberFormat, ILocaleObject<?> localeObject, IPlatformNumberFormatter.Style style) {
        this.mNumberFormat = numberFormat;
        this.mFinalFormat = numberFormat;
        this.mLocaleObject = (LocaleObjectICU)localeObject;
        this.mStyle = style;
        this.mNumberFormat.setRoundingMode(4);
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setCurrency(String currencyCode, IPlatformNumberFormatter.CurrencyDisplay currencyDisplay) throws JSRangeErrorException {
        if (this.mStyle == IPlatformNumberFormatter.Style.CURRENCY) {
            Currency currency = Currency.getInstance((String)currencyCode);
            this.mNumberFormat.setCurrency(currency);
            String currencySymbol = currencyDisplay == IPlatformNumberFormatter.CurrencyDisplay.CODE ? currencyCode : currency.getName(this.mLocaleObject.getLocale(), currencyDisplay.getNameStyle(), null);
            if (this.mNumberFormat instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)this.mNumberFormat;
                DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
                symbols.setCurrencySymbol(currencySymbol);
                decimalFormat.setDecimalFormatSymbols(symbols);
            }
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setGrouping(boolean mGroupingUsed) {
        this.mNumberFormat.setGroupingUsed(mGroupingUsed);
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setMinIntergerDigits(int minimumIntegerDigits) {
        if (minimumIntegerDigits != -1) {
            this.mNumberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setSignificantDigits(IPlatformNumberFormatter.RoundingType roundingType, int minimumSignificantDigits, int maximumSignificantDigits) throws JSRangeErrorException {
        if (this.mNumberFormat instanceof DecimalFormat && roundingType == IPlatformNumberFormatter.RoundingType.SIGNIFICANT_DIGITS) {
            DecimalFormat decimalFormat = (DecimalFormat)this.mNumberFormat;
            if (minimumSignificantDigits >= 0) {
                decimalFormat.setMinimumSignificantDigits(minimumSignificantDigits);
            }
            if (maximumSignificantDigits >= 0) {
                if (maximumSignificantDigits < decimalFormat.getMinimumSignificantDigits()) {
                    throw new JSRangeErrorException("maximumSignificantDigits should be at least equal to minimumSignificantDigits");
                }
                decimalFormat.setMaximumSignificantDigits(maximumSignificantDigits);
            }
            decimalFormat.setSignificantDigitsUsed(true);
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setFractionDigits(IPlatformNumberFormatter.RoundingType roundingType, int minimumFractionDigits, int maximumFractionDigits) {
        if (roundingType == IPlatformNumberFormatter.RoundingType.FRACTION_DIGITS) {
            if (minimumFractionDigits >= 0) {
                this.mNumberFormat.setMinimumFractionDigits(minimumFractionDigits);
            }
            if (maximumFractionDigits >= 0) {
                this.mNumberFormat.setMaximumFractionDigits(maximumFractionDigits);
            }
            if (this.mNumberFormat instanceof DecimalFormat) {
                ((DecimalFormat)this.mNumberFormat).setSignificantDigitsUsed(false);
            }
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setSignDisplay(IPlatformNumberFormatter.SignDisplay signDisplay) {
        if (this.mNumberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.mNumberFormat;
            DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
            switch (signDisplay) {
                case NEVER: {
                    decimalFormat.setPositivePrefix("");
                    decimalFormat.setPositiveSuffix("");
                    decimalFormat.setNegativePrefix("");
                    decimalFormat.setNegativeSuffix("");
                    break;
                }
                case ALWAYS: 
                case EXCEPTZERO: {
                    if (!decimalFormat.getNegativePrefix().isEmpty()) {
                        decimalFormat.setPositivePrefix(new String(new char[]{symbols.getPlusSign()}));
                    }
                    if (decimalFormat.getNegativeSuffix().isEmpty()) break;
                    decimalFormat.setPositiveSuffix(new String(new char[]{symbols.getPlusSign()}));
                }
            }
        }
        return this;
    }

    @RequiresApi(api=24)
    private static MeasureUnit parseUnit(String inUnit) throws JSRangeErrorException {
        for (MeasureUnit unit : MeasureUnit.getAvailable()) {
            if (!unit.getSubtype().equals(inUnit) && !unit.getSubtype().equals(unit.getType() + "-" + inUnit)) continue;
            return unit;
        }
        throw new JSRangeErrorException("Unknown unit: " + inUnit);
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU setUnits(String unit, IPlatformNumberFormatter.UnitDisplay unitDisplay) throws JSRangeErrorException {
        if (this.mStyle == IPlatformNumberFormatter.Style.UNIT) {
            this.mMeasureUnit = PlatformNumberFormatterICU.parseUnit(unit);
            this.mFinalFormat = MeasureFormat.getInstance((ULocale)this.mLocaleObject.getLocale(), (MeasureFormat.FormatWidth)unitDisplay.getFormatWidth(), (NumberFormat)this.mNumberFormat);
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public String format(double n) {
        String result;
        try {
            result = this.mFinalFormat instanceof MeasureFormat && this.mMeasureUnit != null ? this.mFinalFormat.format(new Measure((Number)n, this.mMeasureUnit)) : this.mFinalFormat.format(n);
        }
        catch (NumberFormatException ex) {
            try {
                return NumberFormat.getInstance((ULocale)ULocale.getDefault()).format(n);
            }
            catch (RuntimeException ex2) {
                return NumberFormat.getInstance((ULocale)ULocale.forLanguageTag((String)"en")).format(n);
            }
        }
        return result;
    }

    @Override
    @RequiresApi(api=24)
    public String fieldToString(AttributedCharacterIterator.Attribute attribute, double x) {
        if (attribute == NumberFormat.Field.SIGN) {
            if (Double.compare(x, 0.0) >= 0) {
                return "plusSign";
            }
            return "minusSign";
        }
        if (attribute == NumberFormat.Field.INTEGER) {
            if (Double.isNaN(x)) {
                return "nan";
            }
            if (Double.isInfinite(x)) {
                return "infinity";
            }
            return "integer";
        }
        if (attribute == NumberFormat.Field.FRACTION) {
            return "fraction";
        }
        if (attribute == NumberFormat.Field.EXPONENT) {
            return "exponentInteger";
        }
        if (attribute == NumberFormat.Field.EXPONENT_SIGN) {
            return "exponentMinusSign";
        }
        if (attribute == NumberFormat.Field.EXPONENT_SYMBOL) {
            return "exponentSeparator";
        }
        if (attribute == NumberFormat.Field.DECIMAL_SEPARATOR) {
            return "decimal";
        }
        if (attribute == NumberFormat.Field.GROUPING_SEPARATOR) {
            return "group";
        }
        if (attribute == NumberFormat.Field.PERCENT) {
            return "percentSign";
        }
        if (attribute == NumberFormat.Field.PERMILLE) {
            return "permilleSign";
        }
        if (attribute == NumberFormat.Field.CURRENCY) {
            return "currency";
        }
        if (attribute.toString().equals("android.icu.text.NumberFormat$Field(compact)")) {
            return "compact";
        }
        return "literal";
    }

    @Override
    @RequiresApi(api=24)
    public AttributedCharacterIterator formatToParts(double n) {
        AttributedCharacterIterator iterator;
        try {
            iterator = this.mFinalFormat instanceof MeasureFormat && this.mMeasureUnit != null ? this.mFinalFormat.formatToCharacterIterator(new Measure((Number)n, this.mMeasureUnit)) : this.mFinalFormat.formatToCharacterIterator(n);
        }
        catch (NumberFormatException ex) {
            try {
                return NumberFormat.getInstance((ULocale)ULocale.getDefault()).formatToCharacterIterator((Object)n);
            }
            catch (RuntimeException ex2) {
                return NumberFormat.getInstance((ULocale)ULocale.forLanguageTag((String)"en")).formatToCharacterIterator((Object)n);
            }
        }
        catch (Exception ex) {
            return NumberFormat.getInstance((ULocale)ULocale.forLanguageTag((String)"en")).formatToCharacterIterator((Object)n);
        }
        return iterator;
    }

    @RequiresApi(api=24)
    public static int getCurrencyDigits(String currencyCode) throws JSRangeErrorException {
        try {
            return Currency.getInstance((String)currencyCode).getDefaultFractionDigits();
        }
        catch (IllegalArgumentException ex) {
            throw new JSRangeErrorException("Invalid currency code !");
        }
    }

    @Override
    @RequiresApi(api=24)
    public PlatformNumberFormatterICU configure(ILocaleObject<?> localeObject, String numberingSystem, IPlatformNumberFormatter.Style style, IPlatformNumberFormatter.CurrencySign currencySign, IPlatformNumberFormatter.Notation notation, IPlatformNumberFormatter.CompactDisplay compactDisplay) throws JSRangeErrorException {
        NumberFormat numberFormat;
        if (!numberingSystem.isEmpty()) {
            NumberingSystem numberingSystemObject;
            try {
                numberingSystemObject = NumberingSystem.getInstanceByName((String)JSObjects.getJavaString(numberingSystem));
            }
            catch (RuntimeException ex) {
                throw new JSRangeErrorException("Invalid numbering system: " + numberingSystem);
            }
            if (numberingSystemObject == null) {
                throw new JSRangeErrorException("Invalid numbering system: " + numberingSystem);
            }
            ArrayList<String> numberingSystemList = new ArrayList<String>();
            numberingSystemList.add(JSObjects.getJavaString(numberingSystem));
            localeObject.setUnicodeExtensions("nu", numberingSystemList);
        }
        if (notation == IPlatformNumberFormatter.Notation.COMPACT && (style == IPlatformNumberFormatter.Style.DECIMAL || style == IPlatformNumberFormatter.Style.UNIT)) {
            CompactDecimalFormat.CompactStyle compactStyle = compactDisplay == IPlatformNumberFormatter.CompactDisplay.SHORT ? CompactDecimalFormat.CompactStyle.SHORT : CompactDecimalFormat.CompactStyle.LONG;
            numberFormat = CompactDecimalFormat.getInstance((ULocale)((ULocale)localeObject.getLocale()), (CompactDecimalFormat.CompactStyle)compactStyle);
            this.initialize(numberFormat, localeObject, style);
        } else {
            int numberFormatStyle = style.getInitialNumberFormatStyle(notation, currencySign);
            numberFormat = NumberFormat.getInstance((ULocale)((ULocale)localeObject.getLocale()), (int)numberFormatStyle);
            if (notation == IPlatformNumberFormatter.Notation.ENGINEERING) {
                numberFormat.setMaximumIntegerDigits(3);
            }
            this.initialize(numberFormat, localeObject, style);
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public String[] getAvailableLocales() {
        ULocale[] availableLocales;
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (ULocale locale : availableLocales = ULocale.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }

    @Override
    @RequiresApi(api=24)
    public String getDefaultNumberingSystem(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        return NumberingSystem.getInstance((ULocale)((ULocale)localeObject.getLocale())).getName();
    }
}

