/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.tpch.TpchTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class TpchSplit
implements ConnectorSplit {
    private final TpchTableHandle tableHandle;
    private final int totalParts;
    private final int partNumber;
    private final List<HostAddress> addresses;

    @JsonCreator
    public TpchSplit(@JsonProperty(value="tableHandle") TpchTableHandle tableHandle, @JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalParts") int totalParts, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalParts >= 1 ? 1 : 0) != 0, (Object)"totalParts must be >= 1");
        Preconditions.checkState((totalParts > partNumber ? 1 : 0) != 0, (Object)"totalParts must be > partNumber");
        this.tableHandle = (TpchTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        this.partNumber = partNumber;
        this.totalParts = totalParts;
        this.addresses = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(addresses, (Object)"addresses is null")));
    }

    @JsonProperty
    public TpchTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public int getTotalParts() {
        return this.totalParts;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TpchSplit)) {
            return false;
        }
        TpchSplit tpchSplit = (TpchSplit)o;
        return this.tableHandle.equals(tpchSplit.tableHandle) && this.partNumber == tpchSplit.partNumber && this.totalParts == tpchSplit.totalParts;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableHandle, this.partNumber, this.totalParts});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("partNumber", this.partNumber).add("totalParts", this.totalParts).toString();
    }
}

