/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.udf.thrift;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.thrift.api.udf.PrestoThriftPage;
import com.facebook.presto.thrift.api.udf.ThriftFunctionHandle;
import com.facebook.presto.thrift.api.udf.ThriftUdfPage;
import com.facebook.presto.thrift.api.udf.ThriftUdfResult;
import com.facebook.presto.thrift.api.udf.ThriftUdfService;
import com.facebook.presto.thrift.api.udf.ThriftUdfStats;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;

public class EchoFirstInputThriftUdfService
implements ThriftUdfService {
    private final BlockEncodingSerde blockEncodingSerde;

    @Inject
    public EchoFirstInputThriftUdfService(BlockEncodingSerde blockEncodingSerde) {
        this.blockEncodingSerde = blockEncodingSerde;
    }

    public ListenableFuture<ThriftUdfResult> invokeUdf(ThriftFunctionHandle functionHandle, ThriftUdfPage inputs) {
        ThriftUdfPage result;
        switch (inputs.getPageFormat()) {
            case PRESTO_THRIFT: {
                PrestoThriftPage thriftPage = inputs.getThriftPage();
                if (thriftPage.getThriftBlocks().isEmpty()) {
                    throw new UnsupportedOperationException("No input to echo");
                }
                result = ThriftUdfPage.thriftPage((PrestoThriftPage)new PrestoThriftPage((List)ImmutableList.of(thriftPage.getThriftBlocks().get(0)), inputs.getThriftPage().getPositionCount()));
                break;
            }
            case PRESTO_SERIALIZED: {
                PagesSerde pagesSerde = new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), Optional.empty());
                Page page = pagesSerde.deserialize(inputs.getPrestoPage().toSerializedPage());
                result = ThriftUdfPage.prestoPage((SerializedPage)pagesSerde.serialize(new Page(new Block[]{page.getBlock(0)})));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return Futures.immediateFuture((Object)new ThriftUdfResult(result, new ThriftUdfStats(0L)));
    }
}

