/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftColumnData;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftTypeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public final class PrestoThriftBigint
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final long[] longs;

    @ThriftConstructor
    public PrestoThriftBigint(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="longs") @Nullable long[] longs) {
        Preconditions.checkArgument((boolean)PrestoThriftBigint.sameSizeIfPresent(nulls, longs), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.longs = longs;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public long[] getLongs() {
        return this.longs;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)BigintType.BIGINT.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new LongArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.longs == null ? new long[numberOfRecords] : this.longs);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.longs != null) {
            return this.longs.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftBigint other = (PrestoThriftBigint)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.longs, other.longs);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.longs));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block) {
        return PrestoThriftTypeUtils.fromLongBasedBlock(block, (Type)BigintType.BIGINT, (nulls, longs) -> PrestoThriftBlock.bigintData(new PrestoThriftBigint((boolean[])nulls, (long[])longs)));
    }

    public static PrestoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return PrestoThriftTypeUtils.fromLongBasedColumn(recordSet, columnIndex, totalRecords, (nulls, longs) -> PrestoThriftBlock.bigintData(new PrestoThriftBigint((boolean[])nulls, (long[])longs)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, long[] longs) {
        return nulls == null || longs == null || nulls.length == longs.length;
    }
}

