/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.udf;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

@ThriftStruct(value="FunctionHandle")
public class ThriftFunctionHandle {
    private final String functionName;
    private final List<String> argumentTypes;
    private final String returnType;
    private final String version;

    @ThriftConstructor
    public ThriftFunctionHandle(String functionName, List<String> argumentTypes, String returnType, String version) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.version = Objects.requireNonNull(version, "version is null");
    }

    @ThriftField(value=1)
    public String getFunctionName() {
        return this.functionName;
    }

    @ThriftField(value=2)
    public List<String> getArgumentTypes() {
        return this.argumentTypes;
    }

    @ThriftField(value=3)
    public String getReturnType() {
        return this.returnType;
    }

    @ThriftField(value=4)
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftFunctionHandle other = (ThriftFunctionHandle)obj;
        return Objects.equals(this.functionName, other.functionName) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.argumentTypes, this.returnType, this.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("argumentTypes", this.argumentTypes).add("returnType", (Object)this.returnType).add("version", (Object)this.version).toString();
    }
}

