/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftColumnData;
import com.facebook.presto.thrift.api.datatypes.SliceData;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftVarchar
implements PrestoThriftColumnData {
    private final SliceData sliceType;

    @ThriftConstructor
    public PrestoThriftVarchar(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="sizes") @Nullable int[] sizes, @ThriftField(name="bytes") @Nullable byte[] bytes) {
        this.sliceType = new SliceData(nulls, sizes, bytes);
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.sliceType.getNulls();
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getSizes() {
        return this.sliceType.getSizes();
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public byte[] getBytes() {
        return this.sliceType.getBytes();
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((desiredType.getClass() == VarcharType.class ? 1 : 0) != 0, (String)"type doesn't match: %s", (Object)desiredType);
        return this.sliceType.toBlock(desiredType);
    }

    @Override
    public int numberOfRecords() {
        return this.sliceType.numberOfRecords();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftVarchar other = (PrestoThriftVarchar)obj;
        return Objects.equals(this.sliceType, other.sliceType);
    }

    public int hashCode() {
        return this.sliceType.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block, Type type) {
        return SliceData.fromSliceBasedBlock(block, type, (nulls, sizes, bytes) -> PrestoThriftBlock.varcharData(new PrestoThriftVarchar(nulls, sizes, bytes)));
    }
}

