/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.udf;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.thrift.api.udf.UdfExecutionFailureInfo;
import java.util.Objects;

@ThriftStruct(value="UdfServiceException")
public final class ThriftUdfServiceException
extends Exception {
    private final boolean retryable;
    private final ErrorCode errorCode;
    private final UdfExecutionFailureInfo failureInfo;

    @ThriftConstructor
    public ThriftUdfServiceException(String message, boolean retryable, ErrorCode errorCode, UdfExecutionFailureInfo failureInfo) {
        super(message);
        this.retryable = retryable;
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
    }

    @Override
    @ThriftField(value=1)
    public String getMessage() {
        return super.getMessage();
    }

    @ThriftField(value=2)
    public boolean isRetryable() {
        return this.retryable;
    }

    @ThriftField(value=3)
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @ThriftField(value=4)
    public UdfExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }
}

