/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.udf;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.udf.ThriftUdfPageFormat;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct(value="UdfPage")
public class ThriftUdfPage {
    private final ThriftUdfPageFormat pageFormat;
    private final List<PrestoThriftBlock> thriftBlocks;

    @ThriftConstructor
    public ThriftUdfPage(ThriftUdfPageFormat pageFormat, @Nullable List<PrestoThriftBlock> thriftBlocks) {
        this.pageFormat = pageFormat;
        this.thriftBlocks = thriftBlocks;
    }

    @ThriftField(value=1)
    public ThriftUdfPageFormat getPageFormat() {
        return this.pageFormat;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public List<PrestoThriftBlock> getThriftBlocks() {
        return this.thriftBlocks;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftUdfPage other = (ThriftUdfPage)obj;
        return Objects.equals((Object)this.pageFormat, (Object)other.pageFormat) && Objects.equals(this.thriftBlocks, other.thriftBlocks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageFormat, this.thriftBlocks});
    }

    public static ThriftUdfPage thriftPage(List<PrestoThriftBlock> thriftBlocks) {
        return new ThriftUdfPage(ThriftUdfPageFormat.PRESTO_THRIFT, thriftBlocks);
    }
}

