/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public abstract class AbstractTestApproximateQueries
extends AbstractTestQueries {
    private final Optional<Session> sampledSession;

    protected AbstractTestApproximateQueries(QueryRunner queryRunner) {
        this(queryRunner, (Optional<Session>)Optional.absent());
    }

    protected AbstractTestApproximateQueries(QueryRunner queryRunner, Session sampledSession) {
        this(queryRunner, (Optional<Session>)Optional.of((Object)Preconditions.checkNotNull((Object)sampledSession, (Object)"sampledSession is null")));
    }

    private AbstractTestApproximateQueries(QueryRunner queryRunner, Optional<Session> sampledSession) {
        super(queryRunner);
        this.sampledSession = (Optional)Preconditions.checkNotNull(sampledSession, (Object)"sampledSession is null");
    }

    @Test
    public void testApproximateQueryCount() throws Exception {
        this.assertApproximateQuery("SELECT COUNT(*) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * COUNT(*) FROM orders");
    }

    @Test
    public void testApproximateJoin() throws Exception {
        this.assertApproximateQuery("SELECT COUNT(shipdate) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 4 * COUNT(shipdate) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testApproximateQueryCountCustkey() throws Exception {
        this.assertApproximateQuery("SELECT COUNT(custkey) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * COUNT(custkey) FROM orders");
    }

    @Test
    public void testApproximateQuerySum() throws Exception {
        this.assertApproximateQuery("SELECT SUM(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * SUM(totalprice) FROM orders");
    }

    @Test
    public void testApproximateQueryAverage() throws Exception {
        this.assertApproximateQuery("SELECT AVG(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT AVG(totalprice) FROM orders");
    }

    protected void assertApproximateQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        if (this.sampledSession.isPresent()) {
            this.assertApproximateQuery((Session)this.sampledSession.get(), actual, expected);
        }
    }
}

