/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.H2QueryRunner;
import com.facebook.presto.util.Types;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.airlift.tpch.TpchTable;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

public final class QueryAssertions {
    private static final Logger log = Logger.get(QueryAssertions.class);

    private QueryAssertions() {
    }

    public static void assertQuery(QueryRunner actualQueryRunner, Session actualSession, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering) throws Exception {
        long start = System.nanoTime();
        MaterializedResult actualResults = actualQueryRunner.execute(actualSession, actual).toJdbcTypes();
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = h2QueryRunner.execute(expected, actualResults.getTypes());
        log.info("FINISHED in presto: %s, h2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), Duration.nanosSince((long)start)});
        if (ensureOrdering) {
            Assert.assertEquals((Collection)actualResults.getMaterializedRows(), (Collection)expectedResults.getMaterializedRows());
        } else {
            QueryAssertions.assertEqualsIgnoreOrder(actualResults.getMaterializedRows(), expectedResults.getMaterializedRows());
        }
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected) {
        Assert.assertNotNull(actual, (String)"actual is null");
        Assert.assertNotNull(expected, (String)"expected is null");
        ImmutableMultiset actualSet = ImmutableMultiset.copyOf(actual);
        ImmutableMultiset expectedSet = ImmutableMultiset.copyOf(expected);
        if (!actualSet.equals((Object)expectedSet)) {
            Assert.fail((String)String.format("not equal\nActual %s rows:\n    %s\nExpected %s rows:\n    %s\n", actualSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)actualSet, (int)100)), expectedSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSet, (int)100))));
        }
    }

    public static void assertApproximateQuery(QueryRunner queryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected) throws Exception {
        long start = System.nanoTime();
        MaterializedResult actualResults = queryRunner.execute(session, actual);
        log.info("FINISHED in %s", new Object[]{Duration.nanosSince((long)start)});
        MaterializedResult expectedResults = h2QueryRunner.execute(expected, actualResults.getTypes());
        QueryAssertions.assertApproximatelyEqual(actualResults.getMaterializedRows(), expectedResults.getMaterializedRows());
    }

    public static void assertApproximatelyEqual(List<MaterializedRow> actual, List<MaterializedRow> expected) throws Exception {
        Assert.assertEquals((int)actual.size(), (int)1, (String)"approximate query returned more than one row");
        MaterializedRow actualRow = actual.get(0);
        MaterializedRow expectedRow = expected.get(0);
        for (int i = 0; i < actualRow.getFieldCount(); ++i) {
            String actualField = (String)actualRow.getField(i);
            double actualValue = Double.parseDouble(actualField.split(" ")[0]);
            double error = Double.parseDouble(actualField.split(" ")[2]);
            Object expectedField = expectedRow.getField(i);
            Assert.assertTrue((expectedField instanceof String || expectedField instanceof Number ? 1 : 0) != 0);
            double expectedValue = expectedField instanceof String ? Double.parseDouble((String)expectedField) : ((Number)expectedField).doubleValue();
            Assert.assertTrue((Math.abs(actualValue - expectedValue) < error ? 1 : 0) != 0);
        }
    }

    public static void copyTpchTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) throws Exception {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            QueryAssertions.copyTable(queryRunner, sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH), session);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    public static void copyAllTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session) throws Exception {
        for (QualifiedTableName table : queryRunner.listTables(session, sourceCatalog, sourceSchema)) {
            if (table.getTableName().equalsIgnoreCase("dual")) continue;
            QueryAssertions.copyTable(queryRunner, table, session);
        }
    }

    public static void copyTable(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, String sourceTable, Session session) throws Exception {
        QualifiedTableName table = new QualifiedTableName(sourceCatalog, sourceSchema, sourceTable);
        QueryAssertions.copyTable(queryRunner, table, session);
    }

    public static void copyTable(QueryRunner queryRunner, QualifiedTableName table, Session session) {
        long start = System.nanoTime();
        log.info("Running import for %s", new Object[]{table.getTableName()});
        String sql = String.format("CREATE TABLE %s AS SELECT * FROM %s", table.getTableName(), table);
        long rows = (Long)Types.checkType((Object)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0), Long.class, (String)"rows");
        log.info("Imported %s rows for %s in %s", new Object[]{rows, table.getTableName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }
}

