/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.Index;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;

class TpchIndex
implements Index {
    private final Function<RecordSet, RecordSet> keyFormatter;
    private final Function<RecordSet, RecordSet> outputFormatter;
    private final TpchIndexedData.IndexedTable indexedTable;

    public TpchIndex(Function<RecordSet, RecordSet> keyFormatter, Function<RecordSet, RecordSet> outputFormatter, TpchIndexedData.IndexedTable indexedTable) {
        this.keyFormatter = (Function)Preconditions.checkNotNull(keyFormatter, (Object)"keyFormatter is null");
        this.outputFormatter = (Function)Preconditions.checkNotNull(outputFormatter, (Object)"outputFormatter is null");
        this.indexedTable = (TpchIndexedData.IndexedTable)Preconditions.checkNotNull((Object)indexedTable, (Object)"indexedTable is null");
    }

    public RecordSet lookup(RecordSet rawInputRecordSet) {
        RecordSet inputRecordSet = (RecordSet)this.keyFormatter.apply((Object)rawInputRecordSet);
        RecordSet rawOutputRecordSet = this.indexedTable.lookupKeys(inputRecordSet);
        return (RecordSet)this.outputFormatter.apply((Object)rawOutputRecordSet);
    }
}

