/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.TestingDiscoveryServer;
import com.facebook.presto.tests.TestingPrestoClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import io.airlift.log.Logger;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private final TestingDiscoveryServer discoveryServer;
    private final TestingPrestoServer coordinator;
    private final List<TestingPrestoServer> servers;
    private final Closer closer = Closer.create();
    private final TestingPrestoClient prestoClient;

    public DistributedQueryRunner(Session defaultSession, int workersCount) throws Exception {
        long start;
        Preconditions.checkNotNull((Object)defaultSession, (Object)"defaultSession is null");
        try {
            start = System.nanoTime();
            this.discoveryServer = (TestingDiscoveryServer)this.closer.register((Closeable)new TestingDiscoveryServer(ENVIRONMENT));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            ImmutableList.Builder servers = ImmutableList.builder();
            this.coordinator = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), true));
            servers.add((Object)this.coordinator);
            for (int i = 1; i < workersCount; ++i) {
                TestingPrestoServer worker = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), false));
                servers.add((Object)worker);
            }
            this.servers = servers.build();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        this.prestoClient = (TestingPrestoClient)this.closer.register((Closeable)new TestingPrestoClient(this.coordinator, defaultSession));
        start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        log.info("Added functions in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private static TestingPrestoServer createTestingPrestoServer(URI discoveryUri, boolean coordinator) throws Exception {
        long start = System.nanoTime();
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.read-timeout", (Object)"1h").put((Object)"compiler.interpreter-enabled", (Object)"false").put((Object)"task.max-index-memory", (Object)"16kB").put((Object)"datasources", (Object)"system").put((Object)"distributed-index-joins-enabled", (Object)"true");
        if (coordinator) {
            properties.put((Object)"node-scheduler.include-coordinator", (Object)"false");
            properties.put((Object)"distributed-joins-enabled", (Object)"true");
        }
        TestingPrestoServer server = new TestingPrestoServer(coordinator, (Map)properties.build(), ENVIRONMENT, discoveryUri, (List)ImmutableList.of());
        log.info("Created TestingPrestoServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        return server;
    }

    private boolean allNodesGloballyVisible() {
        for (TestingPrestoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public TestingPrestoClient getClient() {
        return this.prestoClient;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TestingPrestoServer getCoordinator() {
        return this.coordinator;
    }

    public void installPlugin(Plugin plugin) {
        long start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.installPlugin(plugin);
        }
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.createCatalog(catalogName, connectorName, properties);
        }
        log.info("Created catalog %s in %s", new Object[]{catalogName, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        start = System.nanoTime();
        while (!this.isConnectionVisibleToAllNodes(catalogName)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting form connector " + connectorName + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
        log.info("Announced catalog %s in %s", new Object[]{catalogName, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private boolean isConnectionVisibleToAllNodes(String connectorId) {
        for (TestingPrestoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(connectorId);
            if (activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public List<QualifiedTableName> listTables(Session session, String catalog, String schema) {
        return this.prestoClient.listTables(session, catalog, schema);
    }

    public boolean tableExists(Session session, String table) {
        return this.prestoClient.tableExists(session, table);
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return (MaterializedResult)this.prestoClient.execute(sql);
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return (MaterializedResult)this.prestoClient.execute(session, sql);
    }

    public final void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

