/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.tests.tpch.TpchIndexHandleResolver;
import com.facebook.presto.tests.tpch.TpchIndexResolver;
import com.facebook.presto.tests.tpch.TpchIndexSpec;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;

public class IndexedTpchConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final TpchIndexSpec indexSpec;
    private final int defaultSplitsPerNode;

    public IndexedTpchConnectorFactory(NodeManager nodeManager, TpchIndexSpec indexSpec, int defaultSplitsPerNode) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.indexSpec = (TpchIndexSpec)Preconditions.checkNotNull((Object)indexSpec, (Object)"indexSpec is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpch_indexed";
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        final TpchIndexedData indexedData = new TpchIndexedData(connectorId, this.indexSpec);
        return new Connector(){

            public ConnectorMetadata getMetadata() {
                return new TpchMetadata(connectorId);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(connectorId, IndexedTpchConnectorFactory.this.nodeManager, splitsPerNode);
            }

            public ConnectorHandleResolver getHandleResolver() {
                return new TpchIndexHandleResolver(connectorId);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider();
            }

            public ConnectorRecordSinkProvider getRecordSinkProvider() {
                throw new UnsupportedOperationException();
            }

            public ConnectorIndexResolver getIndexResolver() {
                return new TpchIndexResolver(connectorId, indexedData);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)Objects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

