/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestApproximateQueries;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestDistributedQueries
extends AbstractTestApproximateQueries {
    protected AbstractTestDistributedQueries(QueryRunner queryRunner) {
        this(queryRunner, null);
    }

    protected AbstractTestDistributedQueries(QueryRunner queryRunner, ConnectorSession defaultSampledSession) {
        super(queryRunner, defaultSampledSession);
    }

    private void assertCreateTable(String table, @Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertCreateTable(table, query, query, rowCountQuery);
    }

    private void assertCreateTable(String table, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertQuery("CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery("SELECT * FROM " + table, expectedQuery);
        this.assertQueryTrue("DROP TABLE " + table);
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), table));
    }

    @Test
    public void testCreateSampledTableAsSelectLimit() throws Exception {
        this.assertCreateTable("test_limit_sampled", "SELECT orderkey FROM tpch_sampled.tiny.orders ORDER BY orderkey LIMIT 10", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
    }

    @Test
    public void testCreateTableAsSelect() throws Exception {
        this.assertCreateTable("test_simple", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
    }

    @Test
    public void testCreateTableAsSelectGroupBy() throws Exception {
        this.assertCreateTable("test_group", "SELECT orderstatus, sum(totalprice) x FROM orders GROUP BY orderstatus", "SELECT count(DISTINCT orderstatus) FROM orders");
    }

    @Test
    public void testCreateTableAsSelectJoin() throws Exception {
        this.assertCreateTable("test_join", "SELECT count(*) x FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT 1");
    }

    @Test
    public void testCreateTableAsSelectLimit() throws Exception {
        this.assertCreateTable("test_limit", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
    }

    @Test
    public void testRenameTable() throws Exception {
        this.assertQueryTrue("CREATE TABLE test_rename AS SELECT 123 x");
        this.assertQueryTrue("ALTER TABLE test_rename RENAME TO test_rename_new");
        this.assertQueryTrue("DROP TABLE test_rename_new");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename"));
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename_new"));
    }

    @Test
    public void testInsert() throws Exception {
        String query = "SELECT orderdate, orderkey FROM orders";
        this.assertQuery("CREATE TABLE test_insert AS " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query);
        this.assertQuery("INSERT INTO test_insert " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query + " UNION ALL " + query);
        this.assertQueryTrue("DROP TABLE test_insert");
    }

    @Test
    public void testView() throws Exception {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertQueryTrue("CREATE VIEW test_view AS SELECT 123 x");
        this.assertQueryTrue("CREATE OR REPLACE VIEW test_view AS " + query);
        this.assertQuery("SELECT * FROM test_view", query);
        this.assertQuery("SELECT * FROM test_view a JOIN test_view b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM test_view", query);
        String name = String.format("%s.%s.test_view", this.getSession().getCatalog(), this.getSession().getSchema());
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertQueryTrue("DROP VIEW test_view");
    }

    @Test
    public void testViewMetadata() throws Exception {
        String query = "SELECT 123 x, 'foo' y";
        this.assertQueryTrue("CREATE VIEW meta_test_view AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema()));
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{"lineitem", "BASE TABLE"}).row(new Object[]{"meta_test_view", "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"part", "BASE TABLE"}).row(new Object[]{"partsupp", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).row(new Object[]{"supplier", "BASE TABLE"}).build();
        AbstractTestDistributedQueries.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        AbstractTestDistributedQueries.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema()));
        expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"meta_test_view", SqlFormatter.formatSql((Node)new SqlParser().createStatement(query))}).build();
        AbstractTestDistributedQueries.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM meta_test_view");
        expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", true, false, ""}).row(new Object[]{"y", "varchar", true, false, ""}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
        this.assertQueryTrue("DROP VIEW meta_test_view");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*statement is too large.*")
    public void testLargeQueryFailure() throws Exception {
        this.assertQuery("SELECT " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, "1 = 1")), "SELECT true");
    }

    @Test
    public void testLargeQuerySuccess() throws Exception {
        this.assertQuery("SELECT " + Joiner.on((String)" AND ").join(Collections.nCopies(500, "1 = 1")), "SELECT true");
    }

    @Test
    public void testShowSchemasFromOther() throws Exception {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        ImmutableSet schemaNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertTrue((boolean)schemaNames.containsAll((Collection)ImmutableSet.of((Object)"information_schema", (Object)"sys", (Object)"tiny")));
    }

    @Test
    public void testTableSampleSystem() throws Exception {
        int total = this.computeActual("SELECT orderkey FROM orders").getMaterializedRows().size();
        boolean sampleSizeFound = false;
        for (int i = 0; i < 100; ++i) {
            int sampleSize = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE SYSTEM (50)").getMaterializedRows().size();
            if (sampleSize <= 0 || sampleSize >= total) continue;
            sampleSizeFound = true;
            break;
        }
        Assert.assertTrue((boolean)sampleSizeFound, (String)"Table sample returned unexpected number of rows");
    }

    @Test
    public void testTableSampleSystemBoundaryValues() throws Exception {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(fullSample.getMaterializedRows()));
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    private static void assertContains(MaterializedResult actual, MaterializedResult expected) {
        for (MaterializedRow row : expected.getMaterializedRows()) {
            if (actual.getMaterializedRows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s%nActual:%n      %s%nExpected:%n      %s", row, actual, expected));
        }
    }
}

