/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.tpch.TpchIndexSpec;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.testng.annotations.Test;

public abstract class AbstractTestIndexedQueries
extends AbstractTestQueryFramework {
    public static final TpchIndexSpec INDEX_SPEC = new TpchIndexSpec.Builder().addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderkey")).addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderkey", (Object)"orderstatus")).addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderkey", (Object)"custkey")).build();

    protected AbstractTestIndexedQueries(QueryRunner queryRunner) {
        super(queryRunner);
    }

    @Test
    public void testBasicIndexJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testBasicIndexJoinReverseCandidates() throws Exception {
        this.assertQuery("SELECT *\nFROM orders o JOIN (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\n  ON o.orderkey = l.orderkey");
    }

    @Test
    public void testBasicIndexJoinWithNullKeys() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN suppkey % 2 = 0 THEN orderkey ELSE NULL END AS orderkey\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testMultiKeyIndexJoinAligned() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey, CASE WHEN suppkey % 2 = 0 THEN 'F' ELSE 'O' END AS orderstatus\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderstatus = o.orderstatus");
    }

    @Test
    public void testMultiKeyIndexJoinUnaligned() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey, CASE WHEN suppkey % 2 = 0 THEN 'F' ELSE 'O' END AS orderstatus\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderstatus = o.orderstatus AND l.orderkey = o.orderkey");
    }

    @Test
    public void testPredicateDerivedKey() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey\nWHERE o.orderstatus = 'F'");
    }

    @Test
    public void testCompoundPredicateDerivedKey() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey\nWHERE o.orderstatus = 'F'\n  AND o.custkey % 2 = 0");
    }

    @Test
    public void testChainedIndexJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey, CASE WHEN suppkey % 2 = 0 THEN 'F' ELSE 'O' END AS orderstatus\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o1\n  ON l.orderkey = o1.orderkey AND l.orderstatus = o1.orderstatus\nJOIN orders o2\n  ON o1.custkey % 1024 = o2.orderkey");
    }

    @Test
    public void testBasicLeftIndexJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nLEFT JOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNonIndexLeftJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM orders o LEFT JOIN (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\n  ON o.orderkey = l.orderkey");
    }

    @Test
    public void testBasicRightIndexJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM orders o RIGHT JOIN (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\n  ON o.orderkey = l.orderkey");
    }

    @Test
    public void testNonIndexRightJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nRIGHT JOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testIndexJoinThroughAggregation() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT orderkey, COUNT(*)\n  FROM orders\n  WHERE custkey % 8 = 0\n  GROUP BY orderkey\n  ORDER BY orderkey) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testIndexJoinThroughMultiKeyAggregation() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT shippriority, orderkey, COUNT(*)\n  FROM orders\n  WHERE custkey % 8 = 0\n  GROUP BY shippriority, orderkey\n  ORDER BY orderkey) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNonIndexableKeys() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT orderkey % 2 as orderkey\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testComposableIndexJoins() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) x\nJOIN (\n  SELECT o1.orderkey as orderkey, o2.custkey as custkey\n  FROM orders o1\n  JOIN orders o2\n    ON o1.orderkey = o2.orderkey) y\n  ON x.orderkey = y.orderkey\n");
    }

    @Test
    public void testNonComposableIndexJoins() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) x\nJOIN (\n  SELECT l.orderkey as orderkey, o.custkey as custkey\n  FROM lineitem l\n  JOIN orders o\n    ON l.orderkey = o.orderkey) y\n  ON x.orderkey = y.orderkey\n");
    }

    @Test
    public void testOverlappingIndexJoinLookupSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey % 1024 = o.orderkey AND l.partkey % 1024 = o.orderkey");
    }

    @Test
    public void testOverlappingSourceOuterIndexJoinLookupSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nLEFT JOIN orders o\n  ON l.orderkey % 1024 = o.orderkey AND l.partkey % 1024 = o.orderkey");
    }

    @Test
    public void testOverlappingIndexJoinProbeSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderkey = o.custkey");
    }

    @Test
    public void testOverlappingSourceOuterIndexJoinProbeSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nLEFT JOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderkey = o.custkey");
    }

    @Test
    public void testRepeatedIndexJoinClause() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderkey = o.orderkey");
    }

    @Test
    public void testProbeNullInReadahead() throws Exception {
        this.assertQuery("select count(*) from (values (1), (cast(null as bigint))) x(orderkey) join orders using (orderkey)", "select count(*) from orders where orderkey = 1");
    }
}

