/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import org.testng.annotations.Test;

public abstract class AbstractTestApproximateQueries
extends AbstractTestQueries {
    private final ConnectorSession defaultSampledSession;

    protected AbstractTestApproximateQueries(QueryRunner queryRunner, ConnectorSession defaultSampledSession) {
        super(queryRunner);
        this.defaultSampledSession = defaultSampledSession;
    }

    @Test
    public void testApproximateQueryCount() throws Exception {
        this.assertApproximateQuery(this.defaultSampledSession, "SELECT COUNT(*) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * COUNT(*) FROM orders");
    }

    @Test
    public void testApproximateQueryCountCustkey() throws Exception {
        this.assertApproximateQuery(this.defaultSampledSession, "SELECT COUNT(custkey) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * COUNT(custkey) FROM orders");
    }

    @Test
    public void testApproximateQuerySum() throws Exception {
        this.assertApproximateQuery(this.defaultSampledSession, "SELECT SUM(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * SUM(totalprice) FROM orders");
    }

    @Test
    public void testApproximateQueryAverage() throws Exception {
        this.assertApproximateQuery(this.defaultSampledSession, "SELECT AVG(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT AVG(totalprice) FROM orders");
    }
}

