/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.TestingDiscoveryServer;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.testing.Assertions;
import io.airlift.testing.Closeables;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.intellij.lang.annotations.Language;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get((String)"TestQueries");
    private static final String ENVIRONMENT = "testing";
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private final TestingDiscoveryServer discoveryServer;
    private final TestingPrestoServer coordinator;
    private final List<TestingPrestoServer> servers;
    private final HttpClient httpClient;
    private final ConnectorSession session;

    public DistributedQueryRunner(ConnectorSession defaultSession, int workersCount) throws Exception {
        this.session = (ConnectorSession)Preconditions.checkNotNull((Object)defaultSession, (Object)"defaultSession is null");
        try {
            this.discoveryServer = new TestingDiscoveryServer(ENVIRONMENT);
            ImmutableList.Builder servers = ImmutableList.builder();
            this.coordinator = DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), true);
            servers.add((Object)this.coordinator);
            for (int i = 1; i < workersCount; ++i) {
                servers.add((Object)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), false));
            }
            this.servers = servers.build();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        this.httpClient = new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.DAYS)).setReadTimeout(new Duration(10.0, TimeUnit.DAYS)));
        long start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
    }

    private static TestingPrestoServer createTestingPrestoServer(URI discoveryUri, boolean coordinator) throws Exception {
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.read-timeout", (Object)"1h").put((Object)"compiler.interpreter-enabled", (Object)"false").put((Object)"datasources", (Object)"system");
        if (coordinator) {
            properties.put((Object)"node-scheduler.include-coordinator", (Object)"false");
        }
        TestingPrestoServer server = new TestingPrestoServer(coordinator, (Map)properties.build(), ENVIRONMENT, discoveryUri, (List)ImmutableList.of());
        return server;
    }

    private boolean allNodesGloballyVisible() {
        for (TestingPrestoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public ConnectorSession getDefaultSession() {
        return this.session;
    }

    public TestingPrestoServer getCoordinator() {
        return this.coordinator;
    }

    public void installPlugin(Plugin plugin) {
        for (TestingPrestoServer server : this.servers) {
            server.installPlugin(plugin);
        }
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        for (TestingPrestoServer server : this.servers) {
            server.createCatalog(catalogName, connectorName, properties);
        }
        long start = System.nanoTime();
        while (!this.isConnectionVisibleToAllNodes(catalogName)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting form connector " + connectorName + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private boolean isConnectionVisibleToAllNodes(String connectorId) {
        for (TestingPrestoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(connectorId);
            if (activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public List<QualifiedTableName> listTables(ConnectorSession session, String catalog, String schema) {
        return this.coordinator.getMetadata().listTables(session, new QualifiedTablePrefix(catalog, schema));
    }

    public boolean tableExists(ConnectorSession session, String table) {
        QualifiedTableName name = new QualifiedTableName(session.getCatalog(), session.getSchema(), table);
        Optional handle = this.coordinator.getMetadata().getTableHandle(session, name);
        return handle.isPresent();
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.session, sql);
    }

    public MaterializedResult execute(ConnectorSession session, @Language(value="SQL") String sql) {
        Throwable throwable = null;
        try (StatementClient client = new StatementClient(this.httpClient, QUERY_RESULTS_CODEC, this.toClientSession(session), sql);){
            QueryResults results;
            AtomicBoolean loggedUri = new AtomicBoolean(false);
            ImmutableList.Builder rows = ImmutableList.builder();
            List<Type> types = null;
            while (client.isValid()) {
                results = client.current();
                if (!loggedUri.getAndSet(true)) {
                    log.info("Query %s: %s?pretty", new Object[]{results.getId(), results.getInfoUri()});
                }
                if (types == null && results.getColumns() != null) {
                    types = DistributedQueryRunner.getTypes(this.coordinator.getMetadata(), results.getColumns());
                }
                if (results.getData() != null) {
                    rows.addAll(Iterables.transform((Iterable)results.getData(), DistributedQueryRunner.dataToRow(session.getTimeZoneKey(), types)));
                }
                client.advance();
            }
            if (!client.isFailed()) {
                results = new MaterializedResult((List)rows.build(), types);
                return results;
            }
            try {
                QueryError error = client.finalResults().getError();
                assert (error != null);
                if (error.getFailureInfo() != null) {
                    throw error.getFailureInfo().toException();
                }
                throw new RuntimeException("Query failed: " + error.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private ClientSession toClientSession(ConnectorSession connectorSession) {
        return new ClientSession(this.coordinator.getBaseUrl(), connectorSession.getUser(), connectorSession.getSource(), connectorSession.getCatalog(), connectorSession.getSchema(), connectorSession.getTimeZoneKey().getId(), connectorSession.getLocale(), true);
    }

    public final void close() {
        if (this.servers != null) {
            for (TestingPrestoServer server : this.servers) {
                Closeables.closeQuietly((Closeable)server);
            }
        }
        Closeables.closeQuietly((Closeable)this.discoveryServer);
    }

    private static Function<List<Object>, MaterializedRow> dataToRow(final TimeZoneKey timeZoneKey, final List<Type> types) {
        return new Function<List<Object>, MaterializedRow>(){

            public MaterializedRow apply(List<Object> data) {
                Preconditions.checkArgument((data.size() == types.size() ? 1 : 0) != 0, (Object)"columns size does not match types size");
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < data.size(); ++i) {
                    Object value = data.get(i);
                    if (value == null) {
                        row.add(null);
                        continue;
                    }
                    Type type = (Type)types.get(i);
                    if (BooleanType.BOOLEAN.equals(type)) {
                        row.add(value);
                        continue;
                    }
                    if (BigintType.BIGINT.equals(type)) {
                        row.add(((Number)value).longValue());
                        continue;
                    }
                    if (DoubleType.DOUBLE.equals(type)) {
                        row.add(((Number)value).doubleValue());
                        continue;
                    }
                    if (VarcharType.VARCHAR.equals((Object)type)) {
                        row.add(value);
                        continue;
                    }
                    if (DateType.DATE.equals(type)) {
                        row.add(new Date(DateTimeUtils.parseDate((String)((String)value))));
                        continue;
                    }
                    if (TimeType.TIME.equals(type)) {
                        row.add(new Time(DateTimeUtils.parseTime((TimeZoneKey)timeZoneKey, (String)((String)value))));
                        continue;
                    }
                    if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals(type)) {
                        row.add(new Time(DateTimeEncoding.unpackMillisUtc((long)DateTimeUtils.parseTimeWithTimeZone((String)((String)value)))));
                        continue;
                    }
                    if (TimestampType.TIMESTAMP.equals(type)) {
                        row.add(new Timestamp(DateTimeUtils.parseTimestamp((TimeZoneKey)timeZoneKey, (String)((String)value))));
                        continue;
                    }
                    if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals(type)) {
                        row.add(new Timestamp(DateTimeEncoding.unpackMillisUtc((long)DateTimeUtils.parseTimestampWithTimeZone((String)((String)value)))));
                        continue;
                    }
                    throw new AssertionError((Object)("unhandled type: " + type));
                }
                return new MaterializedRow(5, row);
            }
        };
    }

    private static List<Type> getTypes(Metadata metadata, List<Column> columns) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columns, DistributedQueryRunner.columnTypeGetter(metadata)));
    }

    private static Function<Column, Type> columnTypeGetter(final Metadata metadata) {
        return new Function<Column, Type>(){

            public Type apply(Column column) {
                String typeName = column.getType();
                Type type = metadata.getType(typeName);
                if (type == null) {
                    throw new AssertionError((Object)("Unhandled type: " + typeName));
                }
                return type;
            }
        };
    }
}

