/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;

public class CustomSum
implements AggregationFunction {
    public List<Type> getParameterTypes() {
        return null;
    }

    public Type getFinalType() {
        return BigintType.BIGINT;
    }

    public Type getIntermediateType() {
        return BigintType.BIGINT;
    }

    public boolean isDecomposable() {
        return false;
    }

    public Accumulator createAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"custom sum does not support approximate queries");
        return new CustomSumAccumulator(argumentChannels[0], maskChannel, sampleWeightChannel);
    }

    public Accumulator createIntermediateAggregation(double confidence) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"custom sum does not support approximate queries");
        return new CustomSumAccumulator(-1, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    public GroupedAccumulator createGroupedAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"custom sum does not support approximate queries");
        return new CustomSumGroupedAccumulator(argumentChannels[0], maskChannel, sampleWeightChannel);
    }

    public GroupedAccumulator createGroupedIntermediateAggregation(double confidence) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"custom sum does not support approximate queries");
        return new CustomSumGroupedAccumulator(-1, (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    public static class CustomSumGroupedAccumulator
    implements GroupedAccumulator {
        private final int channel;
        private final BooleanBigArray notNull;
        private final LongBigArray sums;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;

        public CustomSumGroupedAccumulator(int channel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.channel = channel;
            this.notNull = new BooleanBigArray();
            this.sums = new LongBigArray();
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        public long getEstimatedSize() {
            return this.notNull.sizeOf() + this.sums.sizeOf();
        }

        public Type getFinalType() {
            return BigintType.BIGINT;
        }

        public Type getIntermediateType() {
            return BigintType.BIGINT;
        }

        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            this.processBlock(groupIdsBlock, page.getBlock(this.channel), (Optional<Block>)this.maskChannel.transform(page.blockGetter()), (Optional<Block>)this.sampleWeightChannel.transform(page.blockGetter()));
        }

        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            this.processBlock(groupIdsBlock, block, (Optional<Block>)Optional.absent(), (Optional<Block>)Optional.absent());
        }

        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.evaluateFinal(groupId, output);
        }

        public void evaluateFinal(int groupId, BlockBuilder output) {
            if (this.notNull.get((long)groupId)) {
                long value = this.sums.get((long)groupId);
                output.appendLong(value);
            } else {
                output.appendNull();
            }
        }

        private void processBlock(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.notNull.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            BlockCursor sampleWeights = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long groupId = groupIdsBlock.getGroupId(position);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight((BlockCursor)masks, (BlockCursor)sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                this.notNull.set(groupId, true);
                long value = sampleWeight * values.getLong();
                this.sums.add(groupId, value);
            }
        }
    }

    public static class CustomSumAccumulator
    implements Accumulator {
        private final int channel;
        private boolean notNull;
        private long sum;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;

        public CustomSumAccumulator(int channel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.channel = channel;
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        public long getEstimatedSize() {
            return 0L;
        }

        public Type getFinalType() {
            return BigintType.BIGINT;
        }

        public Type getIntermediateType() {
            return BigintType.BIGINT;
        }

        public void addInput(Page page) {
            this.processBlock(page.getBlock(this.channel), (Optional<Block>)this.maskChannel.transform(page.blockGetter()), (Optional<Block>)this.sampleWeightChannel.transform(page.blockGetter()));
        }

        private void processBlock(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            BlockCursor sampleWeights = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                long sampleWeight = SimpleAggregationFunction.computeSampleWeight((BlockCursor)masks, (BlockCursor)sampleWeights);
                if (values.isNull() || sampleWeight <= 0L) continue;
                this.notNull = true;
                this.sum += sampleWeight * values.getLong();
            }
        }

        public void addIntermediate(Block block) {
            this.processBlock(block, (Optional<Block>)Optional.absent(), (Optional<Block>)Optional.absent());
        }

        public Block evaluateIntermediate() {
            BlockBuilder out = this.getIntermediateType().createBlockBuilder(new BlockBuilderStatus());
            return this.getBlock(out);
        }

        public Block evaluateFinal() {
            BlockBuilder out = this.getFinalType().createBlockBuilder(new BlockBuilderStatus());
            return this.getBlock(out);
        }

        private Block getBlock(BlockBuilder out) {
            if (this.notNull) {
                out.appendLong(this.sum);
            } else {
                out.appendNull();
            }
            return out.build();
        }
    }
}

