/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.H2QueryRunner;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;

public abstract class AbstractTestQueryFramework {
    private final H2QueryRunner h2QueryRunner;
    protected final QueryRunner queryRunner;
    private static final Logger log = Logger.get(AbstractTestQueries.class);

    protected AbstractTestQueryFramework(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
        this.h2QueryRunner = new H2QueryRunner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true)
    private void close() throws Exception {
        try {
            this.h2QueryRunner.close();
        }
        finally {
            this.queryRunner.close();
        }
    }

    protected ConnectorSession getSession() {
        return this.queryRunner.getDefaultSession();
    }

    public final int getNodeCount() {
        return this.queryRunner.getNodeCount();
    }

    protected MaterializedResult computeActual(@Language(value="SQL") String sql) {
        return this.queryRunner.execute(this.getSession(), sql).toJdbcTypes();
    }

    protected void assertQuery(@Language(value="SQL") String sql) throws Exception {
        this.assertQuery(sql, sql, false);
    }

    public void assertQueryOrdered(@Language(value="SQL") String sql) throws Exception {
        this.assertQuery(sql, sql, true);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        this.assertQuery(actual, expected, false);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        this.assertQuery(actual, expected, true);
    }

    protected void assertQueryTrue(@Language(value="SQL") String sql) throws Exception {
        this.assertQuery(sql, "SELECT true");
    }

    public void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected, boolean ensureOrdering) throws Exception {
        long start = System.nanoTime();
        MaterializedResult actualResults = this.computeActual(actual);
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = this.computeExpected(expected, actualResults.getTypes());
        log.info("FINISHED in presto: %s, h2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), Duration.nanosSince((long)start)});
        if (ensureOrdering) {
            Assert.assertEquals((Collection)actualResults.getMaterializedRows(), (Collection)expectedResults.getMaterializedRows());
        } else {
            AbstractTestQueryFramework.assertEqualsIgnoreOrder(actualResults.getMaterializedRows(), expectedResults.getMaterializedRows());
        }
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected) {
        Assert.assertNotNull(actual, (String)"actual is null");
        Assert.assertNotNull(expected, (String)"expected is null");
        ImmutableMultiset actualSet = ImmutableMultiset.copyOf(actual);
        ImmutableMultiset expectedSet = ImmutableMultiset.copyOf(expected);
        if (!actualSet.equals((Object)expectedSet)) {
            Assert.fail((String)String.format("not equal\nActual %s rows:\n    %s\nExpected %s rows:\n    %s\n", actualSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)actualSet, (int)100)), expectedSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSet, (int)100))));
        }
    }

    protected MaterializedResult computeExpected(@Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        return this.h2QueryRunner.execute(sql, resultTypes);
    }

    public Function<MaterializedRow, String> onlyColumnGetter() {
        return new Function<MaterializedRow, String>(){

            public String apply(MaterializedRow input) {
                Assert.assertEquals((int)input.getFieldCount(), (int)1);
                return (String)input.getField(0);
            }
        };
    }

    public String getExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return explainer.getPlan(SqlParser.createStatement((String)query), planType);
    }

    public String getGraphvizExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return explainer.getGraphvizPlan(SqlParser.createStatement((String)query), planType);
    }

    private QueryExplainer getQueryExplainer() {
        MetadataManager metadata = new MetadataManager(new FeaturesConfig().setExperimentalSyntaxEnabled(true), (TypeManager)new TypeRegistry());
        FeaturesConfig featuresConfig = new FeaturesConfig().setExperimentalSyntaxEnabled(true);
        List optimizers = new PlanOptimizersFactory((Metadata)metadata, new SplitManager(), new IndexManager(), featuresConfig).get();
        return new QueryExplainer(this.queryRunner.getDefaultSession(), optimizers, (Metadata)metadata, featuresConfig.isExperimentalSyntaxEnabled());
    }
}

