/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestApproximateQueries
extends AbstractTestQueries {
    private final ConnectorSession defaultSampledSession;
    private static final Logger log = Logger.get(AbstractTestApproximateQueries.class);

    protected AbstractTestApproximateQueries(QueryRunner queryRunner, ConnectorSession defaultSampledSession) {
        super(queryRunner);
        this.defaultSampledSession = defaultSampledSession;
    }

    @Test
    public void testApproximateQueryCount() throws Exception {
        this.assertApproximateQuery("SELECT COUNT(*) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * COUNT(*) FROM orders");
    }

    @Test
    public void testApproximateQueryCountCustkey() throws Exception {
        this.assertApproximateQuery("SELECT COUNT(custkey) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * COUNT(custkey) FROM orders");
    }

    @Test
    public void testApproximateQuerySum() throws Exception {
        this.assertApproximateQuery("SELECT SUM(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * SUM(totalprice) FROM orders");
    }

    @Test
    public void testApproximateQueryAverage() throws Exception {
        this.assertApproximateQuery("SELECT AVG(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT AVG(totalprice) FROM orders");
    }

    private void assertApproximateQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        long start = System.nanoTime();
        MaterializedResult actualResults = this.computeActualSampled(actual);
        log.info("FINISHED in %s", new Object[]{Duration.nanosSince((long)start)});
        MaterializedResult expectedResults = this.computeExpected(expected, actualResults.getTypes());
        AbstractTestApproximateQueries.assertApproximatelyEqual(actualResults.getMaterializedRows(), expectedResults.getMaterializedRows());
    }

    private static void assertApproximatelyEqual(List<MaterializedRow> actual, List<MaterializedRow> expected) throws Exception {
        Assert.assertEquals((int)actual.size(), (int)1, (String)"approximate query returned more than one row");
        MaterializedRow actualRow = actual.get(0);
        MaterializedRow expectedRow = expected.get(0);
        for (int i = 0; i < actualRow.getFieldCount(); ++i) {
            String actualField = (String)actualRow.getField(i);
            double actualValue = Double.parseDouble(actualField.split(" ")[0]);
            double error = Double.parseDouble(actualField.split(" ")[2]);
            Object expectedField = expectedRow.getField(i);
            Assert.assertTrue((expectedField instanceof String || expectedField instanceof Number ? 1 : 0) != 0);
            double expectedValue = expectedField instanceof String ? Double.parseDouble((String)expectedField) : ((Number)expectedField).doubleValue();
            Assert.assertTrue((Math.abs(actualValue - expectedValue) < error ? 1 : 0) != 0);
        }
    }

    protected MaterializedResult computeActualSampled(@Language(value="SQL") String sql) {
        return this.queryRunner.execute(this.defaultSampledSession, sql);
    }
}

