/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.tests.tpch.TpchIndexHandle;
import com.facebook.presto.tests.tpch.TpchIndexProvider;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TpchIndexMetadata
extends TpchMetadata {
    private final TpchIndexedData indexedData;
    private final Set<String> tableWithExtraColumn = ImmutableSet.of((Object)"orders_extra");

    public TpchIndexMetadata(String connectorId, TpchIndexedData indexedData) {
        super(connectorId);
        this.indexedData = Objects.requireNonNull(indexedData, "indexedData is null");
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        String tableName = tpchTableHandle.getTableName();
        if (this.tableWithExtraColumn.contains(tableName)) {
            tpchTableHandle = new TpchTableHandle(this.getOriginalTpchTableName(tableName), tpchTableHandle.getScaleFactor());
        }
        Map<ColumnHandle, NullableValue> fixedValues = ((Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !indexableColumns.contains(entry.getKey())).filter(entry -> !((NullableValue)entry.getValue()).isNull()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableSet lookupColumnNames = ImmutableSet.builder().addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(indexableColumns))).addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(fixedValues.keySet()))).build();
        if (!this.indexedData.getIndexedTable(tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames).isPresent()) {
            return Optional.empty();
        }
        TupleDomain filteredTupleDomain = tupleDomain;
        if (!tupleDomain.isNone()) {
            filteredTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)tupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(fixedValues.keySet()))));
        }
        TpchIndexHandle indexHandle = new TpchIndexHandle(tableName, tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues(fixedValues));
        return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)indexHandle, filteredTupleDomain));
    }

    public TpchTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        String tableName = schemaTableName.getTableName();
        if (this.tableWithExtraColumn.contains(tableName)) {
            TpchTableHandle originalTableHandle = super.getTableHandle(session, new SchemaTableName(schemaTableName.getSchemaName(), this.getOriginalTpchTableName(tableName)));
            return new TpchTableHandle(schemaTableName.getTableName(), originalTableHandle.getScaleFactor());
        }
        return super.getTableHandle(session, schemaTableName);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        String tableName = ((TpchTableHandle)tableHandle).getTableName();
        if (this.tableWithExtraColumn.contains(tableName)) {
            TpchTableHandle originalTableHandle = new TpchTableHandle(this.getOriginalTpchTableName(tableName), ((TpchTableHandle)tableHandle).getScaleFactor());
            return super.getTableStatistics(session, (ConnectorTableHandle)originalTableHandle, tableLayoutHandle, columnHandles, constraint);
        }
        return super.getTableStatistics(session, tableHandle, tableLayoutHandle, columnHandles, constraint);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        String tableName = tpchTableHandle.getTableName();
        if (this.tableWithExtraColumn.contains(tableName)) {
            ConnectorTableMetadata tableMetadata = super.getTableMetadata(session, (ConnectorTableHandle)new TpchTableHandle(this.getOriginalTpchTableName(tableName), tpchTableHandle.getScaleFactor()));
            ImmutableList.Builder columns = ImmutableList.builder();
            columns.addAll((Iterable)tableMetadata.getColumns());
            columns.add((Object)this.getExtraMapColumnMetadata());
            return new ConnectorTableMetadata(new SchemaTableName(tableMetadata.getTable().getSchemaName(), tableName), (List)columns.build());
        }
        return super.getTableMetadata(session, tableHandle);
    }

    private ColumnMetadata getExtraMapColumnMetadata() {
        return ColumnMetadata.builder().setName("data").setType((Type)new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TpchIndexMetadata.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TpchIndexMetadata.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]))).build();
    }

    private String getOriginalTpchTableName(String tableName) {
        String suffix = "_extra";
        if (tableName != null && tableName.endsWith(suffix)) {
            return tableName.substring(0, tableName.length() - suffix.length());
        }
        return tableName;
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }
}

