/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.tvf.TestTVFConnectorColumnHandle;
import com.facebook.presto.connector.tvf.TestTVFConnectorFactory;
import com.facebook.presto.connector.tvf.TestTVFConnectorPlugin;
import com.facebook.presto.connector.tvf.TestingTableFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.TableFunctionApplicationResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTableFunctionInvocation
extends AbstractTestQueryFramework {
    private static final String TESTING_CATALOG = "testing_catalog1";
    private static final String TABLE_FUNCTION_SCHEMA = "table_function_schema";

    @Override
    protected QueryRunner createQueryRunner() throws Exception {
        return DistributedQueryRunner.builder(TestingSession.testSessionBuilder().setCatalog(TESTING_CATALOG).setSchema(TABLE_FUNCTION_SCHEMA).build()).build();
    }

    @BeforeClass
    public void setUp() {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        BiFunction<ConnectorSession, ConnectorTableHandle, Map> getColumnHandles = (session, tableHandle) -> (Map)IntStream.range(0, 100).boxed().map(i -> "column_" + i).collect(ImmutableMap.toImmutableMap(column -> column, column -> new TestTVFConnectorColumnHandle((String)column, (Type)VarcharType.createUnboundedVarcharType()){}));
        queryRunner.installPlugin((Plugin)new TestTVFConnectorPlugin((ConnectorFactory)TestTVFConnectorFactory.builder().withTableFunctions((Iterable)ImmutableSet.of((Object)new TestingTableFunctions.SimpleTableFunction())).withApplyTableFunction((session, handle) -> {
            if (handle instanceof TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle) {
                TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle functionHandle = (TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle)handle;
                return Optional.of(new TableFunctionApplicationResult((Object)functionHandle.getTableHandle(), (List)functionHandle.getTableHandle().getColumns().orElseThrow(() -> new IllegalStateException("Columns are missing"))));
            }
            throw new IllegalStateException("Unsupported table function handle: " + handle.getClass().getSimpleName());
        }).withGetColumnHandles(getColumnHandles).build()));
        queryRunner.createCatalog(TESTING_CATALOG, "testTVF");
    }

    @Test
    public void testPrimitiveDefaultArgument() {
        this.assertQuery("SELECT boolean_column FROM TABLE(system.simple_table_function(column => 'boolean_column', ignored => 1))", "SELECT true WHERE false");
        this.assertQuery("SELECT boolean_column FROM TABLE(system.simple_table_function(column => 'boolean_column'))", "SELECT true WHERE false");
    }

    @Test
    public void testNoArgumentsPassed() {
        this.assertQuery("SELECT col FROM TABLE(system.simple_table_function())", "SELECT true WHERE false");
    }
}

