/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.statistics.Metric;
import com.facebook.presto.tests.statistics.MetricComparison;
import com.facebook.presto.tests.statistics.StatsContext;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

final class MetricComparator {
    private MetricComparator() {
    }

    static List<MetricComparison> getMetricComparisons(String query, QueryRunner runner, List<Metric> metrics) {
        List<OptionalDouble> estimatedValues = MetricComparator.getEstimatedValues(metrics, query, runner);
        List<OptionalDouble> actualValues = MetricComparator.getActualValues(metrics, query, runner);
        ImmutableList.Builder metricComparisons = ImmutableList.builder();
        for (int i = 0; i < metrics.size(); ++i) {
            metricComparisons.add((Object)new MetricComparison(metrics.get(i), estimatedValues.get(i), actualValues.get(i)));
        }
        return metricComparisons.build();
    }

    private static List<OptionalDouble> getEstimatedValues(List<Metric> metrics, String query, QueryRunner runner) {
        return (List)TransactionBuilder.transaction((TransactionManager)runner.getTransactionManager(), (AccessControl)runner.getAccessControl()).singleStatement().execute(runner.getDefaultSession(), session -> MetricComparator.getEstimatedValuesInternal(metrics, query, runner, session));
    }

    private static List<OptionalDouble> getEstimatedValuesInternal(List<Metric> metrics, String query, QueryRunner runner, Session session) {
        Plan queryPlan = runner.createPlan(session, query, WarningCollector.NOOP);
        OutputNode outputNode = (OutputNode)queryPlan.getRoot();
        PlanNodeStatsEstimate outputNodeStats = queryPlan.getStatsAndCosts().getStats().getOrDefault(queryPlan.getRoot().getId(), PlanNodeStatsEstimate.unknown());
        StatsContext statsContext = MetricComparator.buildStatsContext(queryPlan, outputNode);
        return MetricComparator.getEstimatedValues(metrics, outputNodeStats, statsContext);
    }

    private static StatsContext buildStatsContext(Plan queryPlan, OutputNode outputNode) {
        ImmutableMap.Builder columnVariables = ImmutableMap.builder();
        for (int columnId = 0; columnId < outputNode.getColumnNames().size(); ++columnId) {
            columnVariables.put((Object)((String)outputNode.getColumnNames().get(columnId)), (Object)((VariableReferenceExpression)outputNode.getOutputVariables().get(columnId)));
        }
        return new StatsContext((Map<String, VariableReferenceExpression>)columnVariables.build());
    }

    private static List<OptionalDouble> getActualValues(List<Metric> metrics, String query, QueryRunner runner) {
        String statsQuery = "SELECT " + metrics.stream().map(Metric::getComputingAggregationSql).collect(Collectors.joining(",")) + " FROM (" + query + ")";
        try {
            MaterializedRow actualValuesRow = (MaterializedRow)Iterables.getOnlyElement((Iterable)runner.execute(statsQuery).getMaterializedRows());
            ImmutableList.Builder actualValues = ImmutableList.builder();
            for (int i = 0; i < metrics.size(); ++i) {
                actualValues.add((Object)metrics.get(i).getValueFromAggregationQueryResult(actualValuesRow.getField(i)));
            }
            return actualValues.build();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to execute query to compute actual values: %s", statsQuery), e);
        }
    }

    private static List<OptionalDouble> getEstimatedValues(List<Metric> metrics, PlanNodeStatsEstimate outputNodeStatisticsEstimates, StatsContext statsContext) {
        return (List)metrics.stream().map(metric -> metric.getValueFromPlanNodeEstimate(outputNodeStatisticsEstimates, statsContext)).collect(ImmutableList.toImmutableList());
    }
}

